<?php
// imports
namespace Mtc\Plugins\SiteMenu\Classes;
$path = '../../../../';
require_once $path . 'core/includes/header.inc.php';
require_once $path . 'core/admin/templates/adminheader.html.php';

if (isset($_REQUEST['id'])) {
    // Sanitize request id
    $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_NUMBER_INT);
    // find the menu item by id
    $menu = SiteMenu::find($id);
    // check if menu item exists
    if ($menu) {
        // find all sub_items of the menu item
        $sub_items = SiteMenu::where('parent_id', $menu->id)->get();
        // if sub_items exist, delete all the sub_items first
        if (count($sub_items) > 0) {
            // loop through each sub_item and delete it
            foreach ($sub_items as $sub_item) {
                // delete the sub_item
                $sub_item->delete();
            }
        }
        // delete the menu item
        $menu->delete();
        ?>
        <p>
            <strong>Menu Deleted Successfully</strong>
            <br>
            <a href="../index.php" class="btn btn-black">Go Back</a>
        </p>
        <?php
    }
    else {
        ?>
        <p>
            <strong>Menu item not found.</strong>
            <br>
            <a href="../index.php" class="btn btn-black">Go Back</a>
        </p>
        <?php
    }
}
?>
