<?php

/**
 * @author Nithika Senaweera <nithika.senaweera@mtc.co.uk>
 * @date  2025-05-22
 * @description Site Menu Navigation Manager - Edit / Add Menu Item
 * @copyright MTC Media
 * @version 2.0
 */

namespace Mtc\Plugins\SiteMenu\Classes;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';
require_once $path . 'core/admin/templates/adminheader.html.php';



?>
<script src="./js/sitemenu.js"></script>
<ul class="breadcrumbs el">
    <?php
    require 'breadcrumbs.php';
    ?>
</ul>
<h1>Manage Site Menu</h1>
<p>
    This is the Site Menu Manager. You can add, edit and delete menu items here.
</p>


<?php
        function constructUrl() : string {
            $is_https = $_SERVER['HTTPS'] ?? null;
            $host = $_SERVER['HTTP_HOST'];
            $http_type = ($is_https === 'on') ? "https://" : "http://";
            $api_path = "/site-menu/admin/children/";
            return $http_type . $host . $api_path;
        }
        $client = new \GuzzleHttp\Client();
        $url = constructUrl();
        $menu_items = [];
        if (isset($_REQUEST['id'])) {
            // Sanitize request id
            $parent_id = (int) filter_var($_REQUEST['id'], FILTER_SANITIZE_NUMBER_INT);
            try {
                $response = $client->request('GET', $url,
                    [
                        'json' => [
                            'id' => $parent_id,
                        ]
                    ]
                );

                $menu_items = json_decode($response->getBody(), true);
            } catch (\Exception $e) {
                echo "Failed to load menu: " . $e->getMessage();
            }
        } else {
            try {
                $response = $client->request('GET', $url,
                    [
                        'json' => [
                            'id' => 0,
                        ]
                    ]
                );

                $menu_items = json_decode($response->getBody(), true);
            } catch (\Exception $e) {
                echo "Failed to load menu: " . $e->getMessage();
            }
        }
        ?>
<div class="row">
    <a href="actions/edit.php?parent=<?= $parent_id ?? "" ?>" class="btn btn-black">Add Menu</a>
</div>
        <?php

        if (count($menu_items) > 0) {
?>
    <table id="manage-site-menus" class="manage-items">
        <tr>
            <th class="center">Menu ID</th>
            <th>Name</th>
            <th class="center">Sub Items</th>
            <th class="center">Active</th>
            <th class="center">Edit</th>
            <th class="center">Delete</th>
        </tr>
        <tbody class="tabular">

        <?php
        foreach ($menu_items as $menu) {
            $menuId = $menu['id'];
            $menuName = $menu['name'];
            $menuPublished = $menu['published'];
            ?>
            <tr data-id="<?= htmlspecialchars($menuId); ?>" draggable="true">
                <td class="center">
                    <?= htmlspecialchars(clean_page($menuId)); ?>
                </td>
                <td>
                        <?= htmlspecialchars($menuName) ?>
                </td>
                <td class="center">
                    <a href="index.php?id=<?= htmlspecialchars(clean_page($menuId)); ?>">
                        <i class="fa fa-sitemap"></i>
                    </a>
                </td>
                <td class="center">
                    <?php
                    $sub_items = SiteMenu::where('parent_id', $menuId)->get();
                    if (htmlspecialchars($menuPublished) == 1)
                    {
                        ?>
                            <i class="fa fa-check" style="color:#3ef83e"></i>
                        <?php
                    }
                    else
                    {?>
                            <i class="fa fa-times" style="color:#d72205"></i>
                        <?php
                    }

                    ?>
                </td>
                <td class="center"><a href="actions/edit.php?id=<?= htmlspecialchars(clean_page($menuId)); ?>">
                        <i class="fa fa-edit"></i>
                    </a>
                </td>
                <td class="center">
                    <a
                            class="alert"
                            title="Are you sure you want to delete this menu item?
                            <?php foreach ($sub_items as $sub_item) { echo $sub_item->name . ' ';} ?> will be deleted as well"
                            href="actions/delete.php?id=<?php htmlspecialchars(clean_page($menuId));?>">
                        <i class="fa fa-trash" style="color:#800000"></i>
                    </a>

                </td>
            </tr>
            <?php
        }
        ?>
        </tbody>
    </table>
    <input type="hidden" id="orderbytable" value="site_menu" />
    <input type="hidden" id="orderbyfield" value="order" />
    <?php
} else {
    ?>
    <p>There are currently no menu items added</p>
    <?php
}
?>
