## Admin Area - Site Menu plugin

### Description
This is the admin area for the Site Menu plugin. It allows you to manage the site menu items and their settings.

### Data Flow
The data flow for the Site Menu plugin is as follows:

  - `site_menu`: table
  - `id`: Unique identifier for the menu item
  - `title`: Title of the menu item
  - `url`: URL of the menu item
  - `parent_id`: ID of the parent menu item (if any)
  - `target`: Target attribute for the menu item (e.g., `_blank`, `_self`)


- To communicate with the database, it uses the `SiteMenu` class, which is a laravel elqouent model. Plese refer to the following link to learn more about the eloquent model: [Laravel Eloquent](https://laravel.com/docs/11.x/eloquent).

- The `SiteMenu` class is located in the `plugins/SiteMenu/Classes/SiteMenu.php` directory.

- The `SiteMenu` model uses the namespace`Mtc\Plugins\SiteMenu\Classes`.

- The `site_menu` table is created using a laravel migation. which is located in the `database/migrations` directory. The migration file is named `2024_02_01_090052_database_install.php`. To understand about the migration, please refer to the following link: [Laravel Migration](https://laravel.com/docs/11.x/migrations).
- The table is been seeded intially by the `SiteMenuTableSeeder.php` class, which is located in the `database/seeders` directory. The seeder file is named `SiteMenuTableSeeder.php`. To understand about the seeder, please refer to the following link: [Laravel Seeder](https://laravel.com/docs/11.x/seeding).
- Note: If you do a change to the table structure, please make sure to update the migration file and the seeder file accordingly and run `php artisan migrate:fresh --seed` (Which seeds  the data and run the migrations by dropping all the tables), `php artisan optimize:clear` (This will clear the cache of the bootstrap files) and `php artisan encryption:run` (Which will encrypt the data in the database) commands to update the database.

### Functionality
- `index.php` - This file is the entry point for the admin area of the Site Menu plugin. It handles the routing and displays the appropriate views based on the request.
- `breadcrumbs.php` - This file contains the breadcrumb navigation for the admin area. It helps users navigate through the different sections of the admin panel.
- `actions/edit.php` - This file handles the editing and adding of menu items. It processes the form submission and updates the menu item in the database using the given id.
- `actions/delete.php` - This file handles the deletion of menu items. It processes the request to delete a menu item from the database using the given id. Sub menu items are also deleted if the parent menu item is deleted.

### Author
- **Name**: Nithika Senaweera
- **Email**: [nithika.senaweera@mtc.co.uk](mailto:nithika.senaweera@mtc.co.uk)
- **Company**: MTC Media

### Version Details
- **Version**: 2.0.0
- **Release Date**: 2025-05-21
