<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateSiteMenuTables
 */
class CreateSiteMenuTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('site_menu')) {
            Schema::create('site_menu', function (Blueprint $table) {
                $table->increments('id');
                $table->string('name')->index();
                $table->string('url')->default('#');
                $table->string('category')->default('#');
                $table->integer('published')->default(1)->index();
                $table->integer('parent_id')->default(-1);
                $table->string('target')->default('_self');
                $table->timestamps();
            });
        }


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_menu');
    }
}
