## Site Menu Plugin

This is a very simple feature that allows adding a customizable menu for site with ease. This feature is easy to use as it allows creating menu entries manually as well as dynamically generating menu entries.


## Installation ##
* Download or clone the plugin from the repository.
* Place the plugin folder in the `plugins` directory of your application.
* If the `site_menu` table doesn't exist. Run the migration to create the necessary database table:
  ```
  php artisan db:seed --class=SiteMenuTableSeeder
  ```
* Clear the cache and encrypt the data:
  ```
    php artisan optimize:clear
    php artisan encryption:run
    ```
* Access the admin area of the Site Menu plugin by navigating to `plugins/SiteMenu/admin` in your application.

## Data Flow ##
Described in the `readme.md` file in the `admin` directory of the plugin.
## Functionality ##
- `loader.php` - This file is the entry point for the Site Menu plugin backend. It registers the necessary hooks and actions for the plugin to function properly.
- `admin` - This directory contains the admin area for the Site Menu plugin. It allows you to manage the site menu items and their settings. Refer to the `readme.md` file in the `admin` directory for more details.
- `Classes/SiteMenuRender.php` -  renders the menu items in the frontend using Twig. It converts the menu items into a format that can be used in Twig templates. This done by calling a api call to the `routes/api.php` file.
- `Classes/SiteMenu.php` - This file contains the `SiteMenu` class, which is a Laravel Eloquent model. It is used to interact with the `site_menu` table in the database. Learn more about [Laravel Eloquent](https://laravel.com/docs/11.x/eloquent).
- `Controller/SiteMenuController.php` - This file contains the controller for the Site Menu plugin. It handles the API requests and responses for the plugin. It is used to fetch the menu items and their details from the database using the model. See more about [Laravel Controllers](https://laravel.com/docs/11.x/controllers).
- `css/site_menu.less` - This file contains the styles for the Site Menu plugin. It is used to style the menu items and their appearance in the frontend. NOTE:THIS IS REQUIRED TO REGISTER IN THE INCLUDES.LESS IN THE PROJECT.
- `database/migrations` -  This directory contains all of the migration files for the Site Menu plugin. It is used to create the necessary database tables and structure for the plugin to function properly. Learn more about [Laravel Migration](https://laravel.com/docs/11.x/migrations).
- `database/seeders/SiteMenuTableSeeder.php` - This file contains the seeder for the Site Menu plugin. It is used to seed the initial data into the `site_menu` table. Learn more about [Laravel Seeder](https://laravel.com/docs/11.x/seeding).
- `routes/api.php` - This file contains the API routes for the Site Menu plugin. It defines the endpoints for fetching the menu items and their details. It is used to handle the API requests from the frontend and return the appropriate responses.
- `templates/view/menu.twig` - This file contains the Twig template for rendering the menu items in the frontend. It uses the `SiteMenuRender` class to convert the menu items into a format that can be used in Twig templates.

## Usage ##
Insert where needed:
```
{{ hooks_do_action('load_site_menu',  'menu name') }}
```
### Author
- **Name**: Nithika Senaweera
- **Email**: [nithika.senaweera@mtc.co.uk](mailto:nithika.senaweera@mtc.co.uk)
- **Company**: MTC Media

### Version Details
- **Version**: 2.0.0
- **Release Date**: 2025-05-27
