<?php

use Illuminate\Support\Facades\Route;
use Mtc\Plugins\SiteMenu\Controller\SiteMenuAdminController;
use Mtc\Plugins\SiteMenu\Controller\SiteMenuController;



Route::prefix('site-menu')->group(function () {
    Route::prefix('/admin')->group(function () {
        Route::get('/children/', [SiteMenuAdminController::class, 'children']);
        Route::group(['middleware' => 'auth'], function() {
            Route::get('/', [SiteMenuAdminController::class, 'index'])->name('site-menu-admin.index');
            Route::get('/all', [SiteMenuAdminController::class, 'all']);
            Route::get('/single/{id}', [SiteMenuAdminController::class, 'single'])->whereNumber('id');
            Route::get('/parent/', [SiteMenuAdminController::class, 'parent']);
            Route::post('/reorder/', [SiteMenuAdminController::class, 'orderChange']);

        });
    });

    Route::get('/', [SiteMenuController::class, 'index'])->name('site-menu.index');

    Route::post('/children-by-name', [SiteMenuController::class, 'childrenByName'])->name('site-menu.children-by-name');
});
?>
