<?php
/**
 * Trustpilot Settings Class
 *
 * @package  Mtc_TruspilotAPI
 * @author   Aivars Francis <aivars.francis@mtcmedia.co.uk>
 * @author   Efraim Zakarias <efraim.zakarias@mtcmedia.co.uk>
 */
namespace Mtc\Plugins\TrustpilotAPI\Classes;

use Illuminate\Database\Eloquent\Model;

class TrustpilotSettings extends Model
{
    /**
     * @var String Classes associated table
     */
    protected $table = 'trustpilot_settings';

    /**
     * @var boolean Disables use of eloquent timestamps
     */
    public $timestamps = false;

    /**
     * TrustpilotSettings::getByKey()
     *
     * Returns setting value by key
     *
     * @param string $name
     * @return string
     *
     */
    public function getByKey($key)
    {
        
        $option = self::where('key', '=', $key);

        if ($option->count() == 0) {
            return '';
        } else {
            $option = $option->first();
            return $option->value;
        }
        
    }
}
