<?php

\Route::any('shop/bundles/add-to-basket', [
    'as' => 'shop-bundles-add-to-basket',
    'uses' => 'MtcPharmacy\Bundles\Http\Controllers\BundlesCheckoutController@add_to_basket'
]);


/* Admin pages */

\Route::group([

    'middleware' => ['web'] // Required for Laravel sessions to work.

], function() {

    \Route::get('admin/bundle-types', [
        'as' => 'admin-bundle-types',
        'uses' => 'MtcPharmacy\Bundles\Http\Controllers\Admin\BundleTypesController@manage'
    ]);

    \Route::get('admin/bundle-types/edit/{type_id}', [
        'as' => 'admin-bundle-types-edit',
        'uses' => 'MtcPharmacy\Bundles\Http\Controllers\Admin\BundleTypesController@edit'
    ]);

    \Route::post('admin/bundle-types/edit/{type_id}', [
        'as' => 'admin-bundle-types-update',
        'uses' => 'MtcPharmacy\Bundles\Http\Controllers\Admin\BundleTypesController@update'
    ]);

    \Route::get('admin/bundle-types/items/delete/{item_id}', [
        'as' => 'admin-bundle-types-items-delete',
        'uses' => 'MtcPharmacy\Bundles\Http\Controllers\Admin\BundleTypesController@delete_item'
    ]);

});

