<?php

use Mtc\Shop\Coupon;
use Mtc\Shop\Coupon\Code as CouponCode;
use Illuminate\Database\Eloquent\Model;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$page_meta['title'] = 'Manage Coupons';

$append = '';

if (!empty($_REQUEST['action']) && $_REQUEST['action'] === 'delete' && is_numeric($_REQUEST['delete_id'])) {
    Coupon::find($_REQUEST['delete_id'])->delete();
    CouponCode::where('coupon_id', $_REQUEST['delete_id'])->delete();
}

require_once $path . 'core/admin/templates/adminheader.html.php';

if (!empty($_REQUEST['name'])) {
    $append .= "&name=" . $_REQUEST['name'];
}

if (!empty($_REQUEST['code'])) {
    $append .= "&code=" . $_REQUEST['code'];
}

if (!empty($_REQUEST['action']) && $_REQUEST['action'] === "search") {
    $append .= "&action=search";
}

$rowsPerPage = 25;
$pageNum = empty($_GET['page']) ? 1 : $_GET['page'];
$offset = ($pageNum - 1) * $rowsPerPage;
$pagestoshow = 10;

$coupons = Coupon::search($_REQUEST);
$totalnumrows = $coupons->count();
$coupons = $coupons->orderBy('id', 'DESC')->skip($offset)->take($rowsPerPage)->get();

?>

<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end">Manage Coupons</li>
</ul>

<h1>Manage Coupons</h1>
<?php
include __DIR__ . '/tabnav.php';

?>
<form action="manage.coupons.php" method="get" class="style">
    <fieldset class="<?= (!empty($_REQUEST['action']) && $_REQUEST['action'] === 'search')? 'show' : '' ?>">
        <h1><a class="show el">Search <i class="fa fa-caret-right"></i></a></h1>

        <div class="row">
            <label for="name">Name</label>
            <input type="text" name="name" id="name" value="<?= !empty($_REQUEST['name']) ? clean_page($_REQUEST['name']) : '' ?>">
        </div>

        <div class="row">
            <label for="code">Code</label>
            <input type="text" name="code" id="code" value="<?= !empty($_REQUEST['code']) ? clean_page($_REQUEST['code']) : '' ?>">
        </div>

        <div class="row">
            <label for="usable">Usable coupons</label>
            <input type="checkbox" name="usable" id="usable" value="yes" <?= !empty($_REQUEST['usable']) && $_REQUEST['usable'] === 'yes' ? 'checked' : '' ?> >
        </div>

        <input type="hidden" name="action" value="search">
        <div class="row">
            <div class="search-button"><input type="submit" value="Search" class="BUTTON"/></div>
        </div>
    </fieldset>
</form>
<?php
if ($coupons->count() > 0) {
    ?>
    <table class="manage-items">
        <tr>
            <th>Name</th>
            <th>Code</th>
            <th>Expiry Date</th>
            <th>Structure</th>
            <th>Redemptions / No. of codes</th>
            <th>Type</th>
            <th class="center">Value</th>
            <th class="center">Orders</th>
            <th class="center">Edit</th>
            <th class="center">Delete</th>
        </tr>
        <tbody class="tabular">
        <?php
        $flag = 1;
        foreach ($coupons as $coupon) {
            $flag = !$flag;
            ?>
            <tr id="rorder-<?=$coupon->id?>">
                <td><a href="edit.coupon.php?id=<?= $coupon->id;?>"><?= clean_page($coupon->name);?></a></td>
                <td><?= clean_page($coupon->code);?></td>
                <td><?= date('d/m/Y',strtotime($coupon->exp_date));?></td>
                <td>
                    <?php
                    if ($coupon->structure === 'multi') {
                        ?>
                        <a href='manage.coupons.codes.php?coupon_id=<?=$coupon->id; ?>'>
                            <?= clean_page(Coupon::$coupon_structures[$coupon->structure]); ?>
                        </a>
                        <?php
                    } else {
                        echo clean_page(Coupon::$coupon_structures[$coupon->structure]);
                    }
                    ?>
                </td>
                <td>
                    <?php
                    if ($coupon->structure === 'multi') {
                        echo clean_page(CouponCode::where('coupon_id', $coupon->id)->where('order_id', '0')->count());
                    } else {
                        echo clean_page($coupon->redemptions);
                    }
                    ?>
                </td>
                <td><?= clean_page(Coupon::$coupon_types[$coupon->type]); ?></td>
                <td class="center"><?= clean_page($coupon->value); ?></td>
                <td class="center">
                    <a href="/shop/admin/orders/manage.orders.php?coupon=<?= clean_page($coupon->code); ?>">View</a>
                </td>
                <td class="center">
                    <a href="edit.coupon.php?id=<?= clean_page($coupon->id); ?>" class="edit"><i class="fa fa-pencil"></i></a>
                </td>
                <td class="center">
                    <a href="manage.coupons.php?action=delete&delete_id=<?= clean_page($coupon->id); ?>"
                       class="alert error"
                       title="Are you sure you want to delete this coupon?">
                        <i class="fa fa-times-circle"></i>
                    </a>
                </td>
            </tr>
            <?php
        }
        ?>
        </tbody>
    </table>
    <?php
} elseif (!empty($_REQUEST['action']) && $_REQUEST['action'] === 'search') {
    ?>
    <p>No coupons found matching your search criteria</p>
    <?php
} else {
    ?>
    <p>There are currently no coupons added</p>
    <?php
}

include $path . 'core/admin/templates/pagination.php';

require_once $path . 'core/admin/templates/adminfooter.html.php';
