<?php
/**
 * Custom Field Eloquent model
 *
 * @version 29/09/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop;

use Illuminate\Database\Eloquent\Model;

/**
 * Custom Field Eloquent model.
 * Implements Shop Custom Field management
 *
 * @version 29/09/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class CustomField extends Model
{

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'custom_fields';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'name',
        'type',
        'custom_field_list_id',
        'database_field',
        'quantity',
        'multiple'
    ];

    /**
     * @var array Defined custom field types
     */
    public static $field_types = [
        'text' => 'Text Box',
        'textarea' => 'Text Area',
        'dropdown' => 'Dropdown',
        'map_coords' => 'Map Coordinates',
        'image_upload' => 'Image Upload'
    ];

    /**
     * Define relationship with fields assigned to a set
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function setFields()
    {
        return $this->hasMany(CustomFieldSetField::class, 'custom_field_id');
    }

}