<?php

namespace Mtc\Shop\Events;

use ProductFilter;

/**
 * URL to Selections event, triggered at the end of
 * ProductFilter::urlToSelections().
 *
 * @author Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class FilterUrlToSelections
{
    /**
     * The filter instance.
     *
     * @var null|ProductFilter
     */
    public $filter = null;

    /**
     * The URL passed to ProductFilter::urlToSelections().
     *
     * @var string
     */
    public $url = '';

    /**
     * Initiate the event, storing the filter instance and provided URL.
     *
     * @param ProductFilter $filter The filter that initated the event.
     * @param string        $url    The URL passed to the urlToSelections()
     *                              method.
     *
     * @return void
     */
    public function __construct(ProductFilter $filter, $url = '')
    {
        $this->filter = $filter;
        $this->url = $url;
    }
}
