<?php
/**
 * Item Image Object Eloquent model.
 * @version 20/09/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Item;

use Illuminate\Database\Eloquent\Model;
use Mtc\Shop\Item;

/**
 * Item Image Object Eloquent model.
 * Implements functionality for managing Shop Item Images
 *
 * @version 20/09/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Image extends Model
{
    // Use trait that defines relationship to items
    use BelongsToItem;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'items_images';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'item_id',
        'name',
        'old_location',
        'default',
        'hover',
        'zoom',
        'type',
        'price',
        'alt',
        'colour',
        'order',
    ];

    protected $hidden = [
        'updated_at',
        'created_at',
        'old_location',
    ];

    /**
     * Relationship with item
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function item()
    {
        return $this->belongsTo(Item::class);
    }

    /**
     * Scope - isDefault()
     * Find the default image for item
     *
     * @param \Illuminate\Database\Eloquent\Builder $query Query builder object
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeIsDefault($query)
    {
        return $query->where('default', 1);
    }

    /**
     * Scope - isZoom()
     * Find the zoom image for item
     *
     * @param \Illuminate\Database\Eloquent\Builder $query Query builder object
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeIsZoom($query)
    {
        return $query->where('zoom', 1);
    }

}
