<?php

namespace App\Events;

use Order;

/**
 * Class OrderRefundedEvent
 *
 * Event triggered when an order is refunded
 *
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk
 * @version 24.04.2023
 */
class OrderRefundedEvent
{

    /**
     * @var Order $order
     */
    protected Order $order;

    /**
     * @var $amount
     */
    protected $amount;

    /**
     * @return Order
     */
    public function getOrder(): Order
    {
        return $this->order;
    }

    /**
     * @return mixed
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param Order $order
     * @param $amount
     */
    public function __construct(Order $order, $amount)
    {
        $this->order = $order;
        $this->amount = $amount;
    }
}
