<?php

namespace Mtc\Cms\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;


class AssetGalleryIcon extends Model
{
    protected $table = 'asset_gallery__icons';

    protected $fillable = [
        'filepath',
        'label',
    ];

    private $file_location = 'assetgallery/icons';


    public function getFileUrl()
    {
        return Storage::disk('uploads')->url($this->filepath);
    }


    public static function getAvailable()
    {
        $available = [];

        $icons = self::all();
        foreach ($icons as $icon) {
            $available[$icon->id] = [
                'id' => $icon->id,
                'file_url' => $icon->getFileUrl(),
                'label' => $icon->label,
            ];
        }

        return $available;
    }


    public function storeFile($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);
        $filename = 'icon-' . time() . '.' . $extension;

        return Storage::disk('uploads')->putFileAs($this->file_location, new \Illuminate\Http\File($file), $filename);
    }
}

