<?php

$path = '../../../';
require $path.'core/includes/header.inc.php';

init_request_values([
    'path' => null,
    'text_added' => null,
]);

$page_meta['title'] = 'Manage SEO Headings';

$seo_headings = new SeoHeadings();
$errors = array();
$form = array();

if ($_REQUEST['delete']) {
    $seo_headings->deleteHeading($_REQUEST['delete']);
    header('Location: manage.seo.headings.php?message=success');
    exit;
}

if ($_REQUEST['edit']) {
    $form = $seo_headings->getHeading($_REQUEST['edit']);
}

if ($_REQUEST['action'] == 'update') {

    if (!preg_match('#^/#', $_REQUEST['path'])) {
        $errors[] = 'Your path has to start with a forward slash: /';
    }

    if ($_REQUEST['path'] == '/') {
        $errors[] = 'Use /index.php for home';
    }

    if (count($errors) === 0) {
        $seo_headings->createOrUpdate($_REQUEST['path'], $_REQUEST['text']);
        header('Location: manage.seo.headings.php?message=success');
        exit;
    }
}

if ($_REQUEST['action'] == 'csv') {
    if (!empty($_REQUEST['export'])) {
        header('Location: csv.get.php?type=headings');
        exit;
    }
    elseif ($_REQUEST['import'] != '') {
        SeoCsv::importCsv('headings');
        header('Location: manage.seo.headings.php?message=success');
        exit;
    }
}


if ($_REQUEST['action'] == 'add') {

    $form['path'] = $_REQUEST['path'];
    $form['text_added'] = $_REQUEST['text_added'];

    if (!preg_match('#^/#', $_REQUEST['path'])) {
        $errors[] = 'Your path has to start with a forward slash: /';
    }

    if ($_REQUEST['path'] == '/') {
        $errors[] = 'Use /index.php for home';
    }

    if (count($errors) === 0) {
        $seo_headings->createOrUpdate($_REQUEST['path'], $_REQUEST['text_added']);
        header('Location: manage.seo.headings.php?message=success');
        exit;
    }
}

$seo_headings->getHeadings();

/* * ***********************************************************************************************************************************
 * 														OUTPUT
 * *********************************************************************************************************************************** */

include $path.'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="/admin/seoadmin">Manage SEO</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1>SEO Headings</h1>
<?php
include('tabnav.php');

if (count($errors) > 0) {
    showerrors($errors);
}
if (count($errors) == 0 && $_REQUEST['message'] == 'success') {
    echo showmsg("Operation carried out successfully", "success", $path);
}

include __DIR__.'/templates/csvform.html.php';

// Add H1
if (!$_REQUEST['edit']) {
?>
<form action="<?= $_SERVER['PHP_SELF'] ?>" method="post" class="style">
    <fieldset>
        <h1><a class="show el">Add H1<i class="fa fa-caret-right"></i></a></h1>
        <div class="row">
            <label for="path">Path</label>
            <?php
            if (!$_REQUEST['edit']) {
                ?>
                <input type="text" name="path" id="path" value="<?= clean_page($_REQUEST['path']); ?>">
                <div class="hint el">
                    <i class="fa fa-info-circle"></i>
                    <div style="display: none;" class="text">
                        <h1>Page Path</h1>
                        <p>
                            Link to the page you want to set SEO data for starting with the / after the .co.uk or .com etc
                            <br />Use /index.php for the homepage
                        </p>
                    </div>
                </div>
                <?php
            }
            ?>
        </div>
        <div class="row">
            <label for="text">Heading</label>
            <input name="text_added" type="text" value="<?= clean_page($_REQUEST['text_added']); ?>" />
        </div>
        <input type="hidden" name="action" value="add">
        <input type="submit" class="btn" value="Set Rule"/>
        <div class="search-button"><input type="submit" value="Add" class="BUTTON"/></div>
    </fieldset>
</form>
<?php
}

// Edit Page
if ($_REQUEST['edit']) {
            ?>
<form action="<?= $_SERVER['PHP_SELF'] ?>" method="post" class="style">
    <fieldset>
        <div class="row">
            <label for="path">Path</label>
            <?= clean_page($form['path']); ?>
        </div>
        <div class="row">
            <label for="text">Heading</label>
            <input name="text" type="text" value="<?= clean_page($form['text']); ?>" />
        </div>
        <input type="hidden" name="action" value="update">
        <input type="hidden" name="path" value="<?=clean_page($form['path'])?>">
        <input type="hidden" name="edit" value="<?= $_REQUEST['edit'] ?>">
        <div class="search-button"><input type="submit" value="<?= (!$_REQUEST['edit']) ? 'Add' : 'Edit' ?>" class="BUTTON"/></div>
    </fieldset>
</form>
<?php }

if (!$_REQUEST['edit'] && count($seo_headings->seo_headings) > 0) {
    ?>
    <table class="">
        <tr>
            <th class="center"></th>
            <th>Path</th>
            <th>Heading</th>
            <th class="center"></th>
        </tr>
        <tbody class="tabular ui-sortable">
            <?php
            foreach ($seo_headings->seo_headings as $text) {
                ?>
                <tr>
                    <td>
                        <a href="<?= $text['path'] ?>" target="_blank"><i class="fa fa-eye"></i></a>
                    </td>
                    <td><?= clean_page($text['path']) ?></td>
                    <td><?= substr(clean_page($text['text']), 0 , 200)." ..."; ?></td>
                    <td>
                        <a href="?edit=<?= $text['id'] ?>"><i class="fa fa-pencil"></i></a>
                        &nbsp;
                        <a href="?delete=<?= $text['id'] ?>" class="alert error" title="Are you sure you want to delete this seo heading?"><i class="fa fa-times-circle"></i></a>
                    </td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>

    <?php
}
require_once $path.'core/admin/templates/adminfooter.html.php';
