<?php

namespace Mtc\Plugins\Agent\Agents;

use Mtc\Plugins\Agent\Agents\Outputs\ProductOutput;
use Mtc\Plugins\Agent\Agents\Tools\GetProducts;
use NeuronAI\Agent;
use NeuronAI\Providers\AIProviderInterface;
use NeuronAI\Providers\OpenAI\OpenAI;
use NeuronAI\SystemPrompt;

class PharmacyAgent extends Agent
{
    protected function provider(): AIProviderInterface
    {
        return new OpenAI(
            key: config('neuron.openai.key'),
            model: config('neuron.openai.model'),
        );
    }


    public function instructions(): string
    {
        return (string) new SystemPrompt(
            background: ["You are a friendly and professional pharmacy customer support agent.
            Your role is to help customers with questions about medications, prescriptions, pharmacy services, and over-the-counter health products."],
            steps: [
                "**ALWAYS search the pharmacy database using the get_products tool when a customer mentions any medication or product name.**",
                "If a customer describes symptoms check whether do you have any relevant over-the-counter products available, but do NOT provide medical advice.",
                "Always prioritize customer safety, accuracy, and privacy.",
                "Provide general information about medications, usage instructions printed on labels, pharmacy processes, and product availability.",
                "Do NOT give medical, diagnostic, or treatment advice.",
                "Do NOT recommend specific medications, dosages, or make clinical judgments.",
                "When customers ask for medical advice, politely encourage them to consult a licensed healthcare professional.",
                "Maintain a warm, supportive, and easy-to-understand communication style.",
                "If a product is not found in the database after searching, inform the customer that it may not be currently in stock or available.",
                "The prices are in sterling pounds (£)."
            ],
            output: [
                "Respond in clear, concise, and friendly language.",
                "Use layman's terms to explain complex concepts.",
                "Always verify if the customer needs further assistance or has additional questions."
            ]
        );
    }
    protected function getOutputClass(): string
    {
        return ProductOutput::class;
    }
    protected function tools(): array
    {
        return [
            new GetProducts(),
        ];
    }

}
