<?php

namespace Mtc\Plugins\Agent\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ChatGenerated implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     */
    public string $message;
    public string $productName;
    public $productId;
    public $item;

    public function __construct(string $message, string $productName, $productId, $item)
    {
        $this->message = $message;
        $this->productName = $productName;
        $this->productId = $productId;
        $this->item = $item;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array<int, \Illuminate\Broadcasting\Channel>
     */
    public function broadcastOn(): array
    {
        // This is a Public Channel, meaning anyone can listen.
        return [
            new Channel('public-updates'),
        ];
    }

    /**
     * The name of the broadcast event.
     *
     * @return string
     */
    public function broadcastAs(): string
    {
        return 'new.notification';
    }
}
