<?php
namespace Mtc\Plugins\Agent\Providers;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;
use Mtc\Plugins\Agent\Events\ChatGenerated;
use Mtc\Plugins\Agent\Listeners\SendChatGenerated;

class AgentServiceProvider extends ServiceProvider {

    public function register() {
        // Register any application services.
        $this->loadRoutesFrom(__DIR__ . '/../routes/web.php');
        $this->mergeConfigFrom(__DIR__ . '/../config/neuron.php', 'neuron');



        if (!config('neuron.enabled')) {
            return;
        }
    }

    public function boot(): void {
        $this->registerEvents();
    }

    protected function registerEvents(): void {
        Event::listen(ChatGenerated::class, function (ChatGenerated $event) {});
    }

}
