(function () {
    if (typeof window === 'undefined' || typeof document === 'undefined') {
        return;
    }

    var hasOwn = Object.prototype.hasOwnProperty;

    var initialise = function () {
        var node = document.getElementById('patient-profile-bootstrap');
        if (!node) {
            return;
        }

        var parsed = {};
        try {
            parsed = JSON.parse(node.textContent || '{}');
        } catch (e) {
            parsed = {};
        }

        if (!parsed || typeof parsed !== 'object') {
            parsed = {};
        }

        var bootstrap = (window.PatientProfileBootstrap && typeof window.PatientProfileBootstrap === 'object')
            ? window.PatientProfileBootstrap
            : (window.bootstrap && typeof window.bootstrap === 'object')
                ? window.bootstrap
                : {};

        for (var key in parsed) {
            if (hasOwn.call(parsed, key)) {
                bootstrap[key] = parsed[key];
            }
        }

        window.bootstrap = bootstrap;
        window.PatientProfileBootstrap = bootstrap;

        var routes = bootstrap.routes || {};
        var responses = bootstrap.responses || {};
        bootstrap.responses = responses;
        var lookup = Object.create(null);

        var normalise = function (url) {
            return String(url || '').replace(/\/+$/, '');
        };

        for (var name in routes) {
            if (!hasOwn.call(routes, name)) continue;
            var routeUrl = routes[name];
            if (!routeUrl) continue;
            var norm = normalise(routeUrl);
            lookup[norm] = name;
            var base = norm.replace(/\?.*/, '');
            if (!lookup[base]) {
                lookup[base] = name;
            }
        }

        var findKey = function (url) {
            var norm = normalise(url);
            if (lookup[norm]) return lookup[norm];
            var base = norm.replace(/\?.*/, '');
            return lookup[base] || null;
        };

        var attachInterceptor = function () {
            if (!window.Vue || !window.Vue.http || !window.Vue.http.interceptors) {
                return false;
            }

            window.Vue.http.interceptors.push(function (request, next) {
                var key = findKey(request.url);
                if (key && hasOwn.call(responses, key)) {
                    next(request.respondWith(JSON.stringify(responses[key]), {
                        status: 200,
                        statusText: 'OK',
                        headers: { 'Content-Type': 'application/json' }
                    }));
                    return;
                }
                next();
            });

            return true;
        };

        if (!attachInterceptor()) {
            (function retry() {
                if (!attachInterceptor()) {
                    setTimeout(retry, 50);
                }
            })();
        }

        bootstrap.invalidate = function (name) {
            if (hasOwn.call(responses, name)) {
                delete responses[name];
            }
        };
    };

    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initialise);
    } else {
        initialise();
    }
})();
