<?php
namespace Mtc\Plugins\SeoSchema\Classes;

use Illuminate\Support\Facades\App;
use \Item;

class ItemSchema
{
    /**
     * Add tabNav item to item navigation in admin page
     *
     * @access public
     * @static
     * @param Item $item Currently opened item
     * @param array $request $_REQUEST
     * @return string $nav_item html code for navigation item
     */
    public static function addTabNav(Item $item, array $request)
    {
        $twig = App::make('twig');

        $nav_item = $twig->render('SeoSchema/admin/tabnav.twig', [
            'item' => $item,
            'request' => $request,
            'request_uri' => $_SERVER['REQUEST_URI']
        ]);
        return $nav_item;
    }


}