<?php

/**
 * Static Block Installer
 *
 * This code is used to Install Static blocks on site
 *
 * @category Plugins
 * @package  Mtc_Static_Blocks
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Plugins\StaticBlocks\Classes;
use DateTime;
use MTC\Core\Setting;

if (empty($path)) {
    $path = '../../../../';
    require_once $path . "core/includes/header.inc.php";
    $display_message = true;
}

use Illuminate\Database\Capsule\Manager as Capsule;

$schema = Capsule::connection()->getSchemaBuilder();

if ($schema->hasTable('static_blocks') === false) {
    // Builds the table
    $schema->create(
        'static_blocks', function ($table) {
            $table->increments('id')->unsigned;
            $table->string('type');
            $table->string('name');
            $table->integer('published');
        }
    );
}

if ($schema->hasTable('static_blocks_instances') === false) {
    // Builds the table
    $schema->create(
        'static_blocks_instances', function ($table) {
            $table->increments('id')->unsigned;
            $table->integer('static_block_id');
            $table->string('url');
            $table->string('alt_text');
            $table->integer('size');
            $table->string('image');
            $table->text('content');
            $table->timestamps();
    }
    );
}

if ($schema->hasTable('static_blocks_sizes') === false) {
    // Builds the table
    $schema->create(
        'static_blocks_sizes', function ($table) {
            $table->increments('id')->unsigned;
            $table->string('name');
            $table->integer('width');
            $table->integer('height');
            $table->integer('crop');
            $table->integer('forced');
        }
    );
}


if (!defined('STATIC_BLOCKS_ENABLED')) {
    // Get the path to the admin folder without public_html / fork directory
    $path_to_admin_folder = str_replace(SITE_PATH, '', dirname(__DIR__));

    // Check if defined variable already exists
    $setting_check = Capsule::table("admin_menu")->where('constant', 'STATIC_BLOCKS_ENABLED')->exists();

    if (empty($setting_check)) {
        // Create the admin menu item
        $insert_id = Capsule::table('admin_menu')->insertGetId(
            [
            'sub_id'     => 0,
            'title'      => 'Static Content',
            'path'       => '',
            'activePath' => '',
            'constant'   => 'STATIC_BLOCKS_ENABLED',
            'icon'       => '',
            'new_window' => 0,
            'order'      => 0,
            ]
        );

        // Create the admin menu item
        Capsule::table('admin_menu')->insert(
            [
            'sub_id'     => $insert_id,
            'title'      => 'Static Content',
            'path'       => $path_to_admin_folder,
            'activePath' => $path_to_admin_folder,
            'constant'   => 'STATIC_BLOCKS_ENABLED',
            'icon'       => 'fa fa-desktop',
            'new_window' => 0,
            'order'      => 0,
            ]
        );
    }

    // preinstall original size for storing non-cropped version
    $original_size = new StaticBlockSizes();
    $original_size->name = 'originals';
    $original_size->width = 2000;
    $original_size->height = 2000;
    $original_size->crop = 0;
    $original_size->forced = 0;
    $original_size->save();

    // preinstall default sizes (original and thumbs)
    $thumb_size = new StaticBlockSizes();
    $thumb_size->name = 'thumbs';
    $thumb_size->width = 200;
    $thumb_size->height = 100;
    $thumb_size->crop = 1;
    $thumb_size->forced = 0;
    $thumb_size->save();

    $data = [
        [
            'key'         => 'STATIC_BLOCKS_ENABLED',
            'type'        => 'bool',
            'value'       => 1,
            'module'      => 'STATIC_BLOCKS',
            'description' => 'Turn on/off Static Blocks',
            'created_at'  => new DateTime(),
        ],
        [
            'key'         => 'STATIC_BLOCKS_INSTANCE_COUNT',
            'type'        => 'int',
            'value'       => 1,
            'module'      => 'STATIC_BLOCKS',
            'description' => 'Set the max number of instances for a static block',
            'created_at'  => new DateTime(),
        ],
        [
            'key'         => 'STATIC_BLOCKS_TINYMCE_ENABLED',
            'type'        => 'bool',
            'value'       => 1,
            'module'      => 'STATIC_BLOCKS',
            'description' => 'Turn on/off textarea field for static blocks with tinymce',
            'created_at'  => new DateTime(),
        ],
        [
            'key'         => 'STATIC_BLOCKS_TEXTAREA_ENABLED',
            'type'        => 'bool',
            'value'       => 1,
            'module'      => 'STATIC_BLOCKS',
            'description' => 'Turn on/off textarea field for static blocks without tinymce',
            'created_at'  => new DateTime(),
        ],
        [
            'key'         => 'STATIC_BLOCKS_IMAGE_ENABLED',
            'type'        => 'bool',
            'value'       => 1,
            'module'      => 'STATIC_BLOCKS',
            'description' => 'Turn on/off Image type for static blocks',
            'created_at'  => new DateTime(),
        ],
        [
            'key'         => 'STATIC_BLOCKS_ORIGINAL_SIZE_ID',
            'type'        => 'int',
            'value'       => $original_size->id,
            'module'      => 'STATIC_BLOCKS',
            'description' => 'Size id for Original size for do_not_delete',
            'created_at'  => new DateTime(),
        ],
        [
            'key'         => 'STATIC_BLOCKS_THUMB_SIZE_ID',
            'type'        => 'int',
            'value'       => $thumb_size->id,
            'module'      => 'STATIC_BLOCKS',
            'description' => 'Size id for Thumb size for do_not_delete',
            'created_at'  => new DateTime(),
        ],
    ];

    foreach ($data as $key => $values) {
        if (defined($values['key'])) {
            unset($data[$key]);
        }
    }

    Setting::Insert($data);

}

if ($display_message === true) {
    exit('Install successful');
}
