<?php
use Mtc\Core\PaginationTemplate;
use Mtc\Shop\Category;
use Illuminate\Support\Facades\DB;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';
$page_meta['title'] = 'Manage Category Item Comparison';

$errors = [];

if (empty($_REQUEST['id'])) {
    header('Location: /shop/admin/categories/manage.categories.php');
    exit();
}

$category = (new Category())->find($_REQUEST['id']);

if (filter_input(INPUT_POST, 'action') === 'update') {
    $category->comparison_items()->delete();
    if (!empty($_POST['values'])) {
        foreach ($_POST['values'] as $feature_key => $values) {
            foreach ($values as $item_key => $value) {
                // Do not create if feature name or item name is empty
                if (!empty($_POST['items'][$item_key]) && !empty($_POST['features'][$feature_key])) {
                    $category->comparison_items()->create([
                        'item_name' => $_POST['items'][$item_key],
                        'feature_name' => $_POST['features'][$feature_key],
                        'value' => $value,
                    ]);
                }
            }
        }
    }
    header('Location: /shop/admin/categories/item.comparison.php?id=' . $_REQUEST['id'] . '&message=' . urlencode('Item Comparison saved successfully!'));
    exit();
}

$message = filter_input(INPUT_GET, 'message');

$features = $category->comparison_items()->orderBy('id')->groupBy('feature_name')->pluck('feature_name');
if ($features->count() > 0) {
    $items = $category->comparison_items()->orderBy('id')->where('feature_name', $features[0])->pluck('item_name');
} else {
    $items = new \Illuminate\Support\Collection();
}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>

<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="/shop/admin/categories/manage.categories.php">Categories</a> /</li>
    <li>Item Comparison</li>
</ul>

<h1>Item Comparison</h1>

<?php
include __DIR__ . '/tabnav.php';

if (!empty($errors)) {
    showerrors($errors);
}
if (!empty($message)) {
    echo showmsg($message, 'success', $path);
}
?>

<form method="post">
    <table class="manage-items">
        <tbody class="tabular">
        <tr>
            <td nowrap="">Feature / Item</td>
            <?php
            $j = 0;
            foreach ($items as $j => $item) {
                ?>
                <td><input type="text" value="<?= clean_page($item); ?>" name="items[<?= $j; ?>]" /></td>
                <?php
            }
            ?>
            <td><input type="text" value="" name="items[<?= $j + 1; ?>]" placeholder="New item..." /></td>
        </tr>
            <?php
                $k = 0;
                foreach ($features as $k => $feature) {
                    ?>
                    <tr>
                        <td><input type="text" value="<?= clean_page($feature); ?>" name="features[<?= $k; ?>]" /></td>
                        <?php
                        $j = 0;
                        foreach ($items as $j => $item) {
                        ?>
                        <td><input type="text" value="<?= clean_page($category->comparison_items()->where('item_name', $item)->where('feature_name', $feature)->first()->value); ?>" name="values[<?= $k; ?>][<?= $j; ?>]" /></td>
                        <?php
                        }
                        ?>
                        <td><input type="text" value="" name="values[<?= $k; ?>][<?= $j + 1; ?>]" /></td>
                    </tr>
                    <?php
                }
            ?>
        <tr>
            <td><input type="text" value="" name="features[<?= $k + 1; ?>]" placeholder="New feature..." /></td>
            <?php
            $j = 0;
            foreach ($items as $j => $item) {
                ?>
                <td><input type="text" value="" name="values[<?= $k + 1; ?>][<?= $j; ?>]" /></td>
                <?php
            }
            ?>
            <td><input type="text" value="" name="values[<?= $k + 1; ?>][<?= $j + 1; ?>]" /></td>
        </tr>
        </tbody>
    </table>
    <input type="submit" value="Save" />
    <input type="hidden" name="action" value="update">
</form>
<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
