<?php
$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$item = new Item();

$page_meta['title'] = 'Product Delivery';

if (!empty($_REQUEST['id'])) {
    $item->Get_Item($_REQUEST['id']);
}

if (isset($_REQUEST["action"]) && $_REQUEST["action"] == "update") {
    foreach ($_REQUEST["item_delivery_rate"] as $key1 => $value1) {
        if ((float)$value1["rate"] < 0) {
            $errors[] = "Delivery rate must be defined for every delivery method";
            break;
        }
    }
    if (count($errors) == 0) {
        ItemDeliveryRate::where("item_id", "=", (int)$_REQUEST["id"])->delete();
        foreach ($_REQUEST["item_delivery_rate"] as $key1_delivery_method_id => $value1_delivery_method_rate) {
            $item_delivery_rate = new ItemDeliveryRate();
            $item_delivery_rate->delivery_method_id = $key1_delivery_method_id;
            $item_delivery_rate->item_id = $_REQUEST["id"];
            $item_delivery_rate->rate = $value1_delivery_method_rate["rate"];
            $item_delivery_rate->save();
        }
    }
}

$delivery_methods = DeliveryMethod::all();
$item_delivery_rates = ItemDeliveryRate::all()->keyBy("delivery_method_id");

require_once $path . 'core/admin/templates/adminheader.html.php';

?>

    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li><a href="/shop/admin/products/manage.products.php">Manage Products</a> /</li>
        <li>
            <a href="item.php?id=<?= clean_page($_REQUEST['id']); ?>">
                <?= clean_page(item_name($_REQUEST['id'])); ?>
            </a>
            /
        </li>
        <li class="end">Product Delivery</li>
    </ul>

    <h1>Product Delivery</h1>

<?php
require 'tabnav.php';
if (sizeof($errors) > 0) {
    showerrors($errors);
}
if ((sizeof($errors) == 0 && isset($_REQUEST['action'])) || $_REQUEST['confirm'] == 'added') {
    echo showmsg("Item delivery rates updated", "success", $path);
}
?>

<?php
if ($delivery_methods != null && count($delivery_methods) > 0) { ?>
    <form action="" method="post" name="item" class="style">
        <table class="manage-items">
            <tbody>
            <tr>
                <th>Delivery Method</th>
                <th>Rate</th>
            </tr>
            </tbody>
            <?php
            foreach ($delivery_methods as $key1 => $value1) { ?>
            <tbody class="tabular">
            <tr id="rorder-1">
                <td>
                    <?php print($value1->name); ?>
                </td>
                <td>
                    <input type="text" value="<?= $item_delivery_rates[$value1->id]->rate ?>"
                           name="item_delivery_rate[<?= $value1->id ?>][rate]"/>
                    <input type="hidden" value="<?= $value1->id ?>"
                           name="item_delivery_rate[<?= $value1->id ?>][delivery_method_id]"/>
                </td>
            </tr>
            <?php
            }
            ?>
            </tbody>
        </table>
        <div>
            <input type="hidden" name="action" value="update"/>
            <input type="hidden" name="id" value="<?= (int)$_REQUEST['id'] ?>"/>
            <input type="submit" value="Save"/>
        </div>
    </form>
    <?php
} else { ?>
    There are no delivery methods defined yet.
    <?php
}
?>

<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
