<?php
/**
 * Basket page for shop
 * Loads and renders templates.
 * Data handling is managed in /shop/checkout/ajax.php
 *
 * @author Martins Fridenbergs
 * @version 20/08/16
 */
use Mtc\Modules\Members\Models\Member;

$path = '../../';
require_once $path . 'core/includes/header.inc.php';
$basket = new Basket();
// Reset so that the ID Service can review basket
$basket->resetSession();
$basket->Go_Basket();

if (!is_array($basket->limit_error)) {
    $basket->limit_error = (array) ($basket->limit_error ?? []);
}

$basket_state_list = $basket->getBasketStateList();
$basket_has_postcodes = $basket->getBasketHasPostcodes();
$basket_placeholder_image = false;
if (!empty($placeholder_images['item_small']['value'])) {
    $basket_placeholder_image = '/' . $image_folders['product_folders']['thumbs']['path']
        . '/' . $placeholder_images['item_small']['value'];
}

$initial_payload = [
    'basket' => $basket,
    'titles' => Member::$titles,
    'genders' => Member::$genders,
    'countries' => $basket_countries,
    'currencies' => $GLOBALS['enabled_currencies'],
    'state_list' => $basket_state_list,
    'has_postcodes' => $basket_has_postcodes,
    'basket_placeholder_image' => $basket_placeholder_image,
    'how_did_you_hear_about_us_choices' => explode("\n", BASKET_HOW_DID_YOU_HEAR_ABOUT_US_CHOICES),
];

$page_meta['title'] = 'Delivery | ' . config('app.name');
$page_meta['robots'] = 'noindex, nofollow';

if (!empty($member)) {
    $member->emptyPassword = $member->emptyPassword();
}

//Disable PAF
$settings['PAF_ENABLED'] = true;

// Render the template
echo $twig->render('shop/basket/index.twig', [
    'page_meta' => $page_meta,
    'basket_countries' => $basket_countries,
    'hide_inputs' => 0,
    'basket' => $basket,
    'paf_enabled' => $settings['PAF_ENABLED'],
    'initial_payload' => $initial_payload,
]);
