<?php
    /**
     * Set the following variables before including this file:
     * $totalnumrows - total number of rows to paginate
     * $rowsPerPage - number of rows per page
     * $pageNum - current page
     * $append - optional. extra variables to append on the query string, e.g. &catid=1&brandid=2
     * $pagestoshow - maximum number of pages to show
     **/

if (! isset($append)) {
    $append = '';
}

    $startdots = $enddots = '<li class="dots">&hellip;</li>';
    $maxPage = ceil($totalnumrows/$rowsPerPage);
    if ($maxPage > 1) {
        $self = $_SERVER['PHP_SELF'];
        $nav  = '';
        if ($pageNum == '') {
            $pageNum = 1;
        }
        if ($pagestoshow == '') {
            $pagestoshow = 10;
        }
        $startpage = $pageNum - floor($pagestoshow/2);
        if ($startpage <= 1) {
            $startpage = 1;
            $startdots = '';
        }
        $endpage = $startpage + $pagestoshow - 1;
        if ($endpage >= $maxPage) {
            $endpage = $maxPage;
            $enddots = '';
        }

        for ($page = $startpage; $page <= $endpage; $page++) {
           if ($page == $pageNum) {
              $nav .= "<li class=\"active\"><a>".$page."</a></li>"; // no need to create a link to current page
           } else {
              $nav .= "<li><a href=\"".$self."?page=".$page.$append."\">".$page."</a></li>";
           }
        }

        // creating previous and next link
        // plus the link to go straight to
        // the first and last page

        if ($pageNum > 1) {
           $page  = $pageNum - 1;
           $prev  = "<li class=\"prev\"><a href=\"".$self."?page=".$page.$append."\" rel=\"prev\">Prev</a></li>";

           $first = "<li class=\"first\"><a href=\"".$self."?page=1".$append."\">First Page</a></li>";
        } else {
           $prev  = ''; // we're on page one, don't print previous link
           $first = ''; // nor the first page link
        }

        if ($pageNum < $maxPage) {
           $page = $pageNum + 1;
           $next = "<li class=\"next\"><a href=\"".$self."?page=".$page.$append."\" rel=\"next\">Next</a></li>";

           $last = "<li class=\"last\"><a href=\"".$self."?page=".$maxPage.$append."\">Last Page</a></li>";
        } else {
           $next = ''; // we're on the last page, don't print next link
           $last = ''; // nor the last page link
        }

        ?>
            <ul class="pagination clear">
                <?php echo $first,$prev,$startdots,$nav,$enddots,$next,$last; ?>
            </ul>
            <ul class="paginationInfo" style="display:none; visibility:hidden;">
                <li class="pageNum"><?= clean_page($pageNum) ?></li>
                <li class="rowsPerPage"><?= clean_page($rowsPerPage) ?></li>
            </ul>
     <?php }
