$(document).ready(function () {
    'use strict';

    $('.js_tabs').mtcTabs({
        responsive: [
            {
                breakpoint: (window.breakpoints.tablet + 1),
                settings: {
                    mode: 'accordion',
                    beforeChange: function () {
                        console.log('beforeChange tablet');
                    },
                    afterChange: function () {
                        console.log('afterChange tablet');
                    },
                }
            },
            {
                breakpoint: (window.breakpoints.mobile + 1),
                settings: {
                    mode: 'select',
                    beforeChange: function () {
                        console.log('beforeChange mobile');
                    },
                    afterChange: function () {
                        console.log('afterChange mobile');
                    },
                }
            }
        ]
    });

    $('.js_tabs2').mtcTabs({
        mode: 'accordion',
        responsive: [
            {
                breakpoint: 800,
                settings: {
                    mode: 'tabs'
                }
            }
        ]
    });

    $('.js_tabs3').mtcTabs({
        active: 2,
        responsive: [
            {
                breakpoint: 800,
                settings: {
                    mode: 'select'
                }
            }
        ]
    });

    $('.js_disable').on('click', function (e) {
        e.preventDefault();
        $('.js_tabs').mtcTabs('destroy');
    });

    $('.js_disable2').on('click', function (e) {
        e.preventDefault();
        $('.js_tabs2').mtcTabs('destroy');
    });

    $('.js_disable3').on('click', function (e) {
        e.preventDefault();
        $('.js_tabs3').mtcTabs('destroy');
    });
});
