<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('active_substances', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();
            $table->timestamps();
        });

        Schema::create('item_active_substance', function (Blueprint $table) {
            $table->integer('item_id');
            $table->unsignedBigInteger('active_substance_id');
            $table->timestamps();

            $table->primary(['item_id', 'active_substance_id']);
            $table->foreign('item_id')->references('id')->on('items')->onDelete('cascade');
            $table->foreign('active_substance_id')->references('id')->on('active_substances')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('item_active_substance');
        Schema::dropIfExists('active_substances');
    }
};
