<?php
/**
 * Feefo Reviews Settings page
 *
 * @category Plugins
 * @package  Mtc_Plugins
 * @author   Davis Lasis <davis.lasis@mtcmedia.co.uk>
 * @version v3.0
 */
namespace Mtc\Plugins\FeefoReviews\Classes;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$page_meta['title'] = 'Feefo Reviews';

$settings_map = FeefoReviewsSettings::columnMap();

if (!empty($_POST['action']) && $_POST['action'] == 'update') {
    $update_fields = [];
    foreach ($settings_map as $fieldset_title => $fieldset) {
        foreach ($fieldset as $field => $title) {
            $update_fields[$field] = $_POST[$field];
        }
    }
    FeefoReviewsSettings::where('id', 1)->update($update_fields);
}

$settings = FeefoReviewsSettings::find(1);

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="/plugins/FeefoReviews/admin/">Feefo Reviews</a> /</li>
    <li class="end">Feefo Reviews Settings</li>
</ul>
<h1>Feefo Reviews Settings</h1>

<?php
require_once 'tabnav.php';
if (!empty($message)) {
    echo showmsg($message, 'success', $path);
}
if (!empty($errors)) {
    showerrors($errors);
}
?>

<form method="post" class="style">
    <?php
    foreach ($settings_map as $fieldset_title => $fieldset) {
        ?>
            <fieldset class="show">
            <h1>
                <a class="show el">
                    <?= ucfirst($fieldset_title) ?>
                    <i class="fa fa-caret-right"></i>
                </a>
            </h1>
        <?php
        foreach ($fieldset as $field => $title) {
            ?>

            <div class="row">
                <label for="<?= $field ?>"><?= $title ?></label>
                <input type="text" name="<?= $field ?>" id="<?= $field ?>" value="<?= clean_page($settings->$field) ?>" />
            </div>

            <?php
        }
        ?>
        </fieldset>
        <?php
    }
    ?>

    <input type="hidden" name="action" value="update" />

    <div class="saveButton">
        <button type="submit" name="submit" class="btn">Update</button>
    </div>
</form>

<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
