<?php

namespace Mtc\Plugins\MtcUnioIntegration\Classes;

use Illuminate\Support\Facades\Event;
use Mtc\Modules\Members\Classes\Events\SavedMember;
use Mtc\Modules\Members\Models\Member;
use Mtc\Plugins\MtcUnioIntegration\Classes\QueueMessageToUnio as Q_OUT;
use Mtc\Plugins\NHS\Classes\NHSMember;


class Helper
{

    public static function register_event_listeners()
    {
        Event::listen(SavedMember::class, function($event) {
            if (Q_OUT::isEntityReadyToBeSynced(Q_OUT::ENTITY_MEMBER, $event->member)) {
                Q_OUT::enqueue(Q_OUT::ENTITY_MEMBER, $event->member->id);
            }
        });

        Event::listen('Member@saved', function (Member $member) {
            if (Q_OUT::isEntityReadyToBeSynced(Q_OUT::ENTITY_MEMBER, $member)) {
                Q_OUT::enqueue(Q_OUT::ENTITY_MEMBER, $member->id);
            }
        });

        Event::listen('NHSMember@saved', function (NHSMember $nhs_member) {
            if (Q_OUT::isEntityReadyToBeSynced(Q_OUT::ENTITY_MEMBER, $nhs_member->member)) {
                Q_OUT::enqueue(Q_OUT::ENTITY_MEMBER, $nhs_member->member->id);
            }

            if (Q_OUT::isEntityReadyToBeSynced(Q_OUT::ENTITY_EXEMPTION, $nhs_member->member)) {
                Q_OUT::enqueue(Q_OUT::ENTITY_EXEMPTION, $nhs_member->member->id);
            }
        });

        Event::listen('Order@updateStatus', function(\Order $order) {
            Q_OUT::enqueue(Q_OUT::ENTITY_ORDER, $order->getId());
        });
    }

}
