<?php

/**
 * Recently Viewed Items
 *
 * Show any recently viewed items where twig template is placed
 *
 * @author Andrew Morgan <andrew.morgan@mtcmedia.co.uk>
 */

use \Mtc\Plugins\RecentlyViewed\Classes\RecentlyViewed;

// Add twig function to allow calling via {{ recently_viewed($limit) }}
$twig->addFunction(
    new \Twig\TwigFunction(
        'recently_viewed', function ($limit = 4, $currently_view = 0) use ($twig) {
            $recently_viewed = RecentlyViewed::getRecentlyViewed($twig, $limit, $currently_view);

            return $twig->render('shop/item/recently_viewed.twig', compact('recently_viewed'));
        }
    )
);
