<?php
/**
 * Static Block Parser Class
 *
 * This code is used to parse calls for Static Blocks based on argument count
 *
 * @category Plugins
 * @package  Mtc_Static_Blocks
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Plugins\StaticBlocks\Classes;

/**
 * Static Block Parser Class.
 * Simple Class that determines argument which method for displaying a block is necessary
 *
 * @category Plugins
 * @package  Mtc_Static_Blocks
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class StaticBlockParser
{
    public static function __callStatic($method, $arguments) {
        if ($method == 'getBlock' && count($arguments) == 3) {
            $method = "getBlockWithPlaceholders";
        }
        call_user_func_array("Mtc\\Plugins\\StaticBlocks\\Classes\\StaticBlocks::$method", $arguments);
    }
}
