<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group.
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

/*
|--------------------------------------------------------------------------
| Component Registry API Routes
|--------------------------------------------------------------------------
*/

Route::get('components', [
    'as' => 'api-components',
    'uses' => 'App\Http\Controllers\ComponentRegistryApiController@index'
]);

Route::get('components/{path}', [
    'as' => 'api-component-detail',
    'uses' => 'App\Http\Controllers\ComponentRegistryApiController@show'
])->where('path', '.*');