<?php

namespace Mtc\Shop\Checkout;

use Illuminate\Database\Eloquent\Model;


class WorldpayLog extends Model
{

    protected $table = 'worldpay_responses';

    protected $fillable = [
        'type',
        'order_id',
        'response',
    ];


    public static function saveResponse(String $response, int $order_id, $type = 'n/a')
    {
        self::create([
            'order_id' => $order_id,
            'type' => $type,
            'response' => $response,
        ]);
    }

}
