<?php
namespace Mtc\Shop;

use Illuminate\Database\Eloquent\Model;

/**
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class DeliveryMethodRate extends Model
{
    protected $fillable = [
        'weight_min',
        'weight_max',
        'line_cost',
        'kg_cost',
    ];

    /**
     * Define the relationship to Restricted categories
     * @return \Illuminate\Database\Eloquent\Relations\belongsTo
     */
    public function method()
    {
        return $this->belongsTo(\DeliveryMethod::class, 'method_id');
    }

}
