function panelInit(dom_scope) {
    if ( typeof dom_scope === 'undefined' || dom_scope === false || dom_scope === "" || dom_scope === 0 ) {
        dom_scope = '#workArea';
    }

    $(dom_scope).find('.hint').on("click", function(event) {
        cmsPreventDefault(event);
        showHelpDialogue($(this));
        return false;
    });

    $(dom_scope).find('.page-copy-btn').on("click", function(event){
        cmsPreventDefault(event);
        copyPagesDialogue(
            [getPageId("live")]
        );
        return false;
    });

    $(dom_scope).find('.toggle-slug-field-btn').on("click", function(event){
        cmsPreventDefault(event);
        return toggleSlugField($(this));
    });

    $(dom_scope).find('.create-trigger-btn').on("click", function(event){
        cmsPreventDefault(event);
        return createTrigger($(this));
    });

    $(dom_scope).find('.paste-page-btn').on("click", function(event){
        cmsPreventDefault(event);
        pagePasteDialog();
        return false;
    });

    $(dom_scope).find('.pastePagesIntoListing').on("click", function(event){
        cmsPreventDefault(event);
        pagePasteDialog("listing_tab");
        return false;
    });

    $(dom_scope).find('.deleteAllListedPages').on("click", function(event){
        cmsPreventDefault(event);
        if (busyLoading()) {
            return false;
        }
        deleteAllListedPagesDialog(
            getListingPageListedPageIDs()
        );
        return false;
    });

    $(dom_scope).find('.page-listing-container-info-btn').fancybox({
        type: 'iframe',
        fitToView : false,
        autoSize : false,
        height : 600,
        width : 800
    });

    $(dom_scope).find('.copy-page-pagedata-btn').on("click", function(event){
        cmsPreventDefault(event);
        pagedataCopyBtn($(this));
        return false;
    });

    $(dom_scope).find('.paste-page-pagedata-btn').on("click", function(event){
        cmsPreventDefault(event);
        pagedataPasteBtn($(this));
        return false;
    });

    $(dom_scope).find(".add-page-pagedata-btn").on("click",function(event){
        cmsPreventDefault(event);
        addPagedata($(this));
    });

    $(dom_scope).find(".deletePageBtn").on("click",function(event){
        cmsPreventDefault(event);
        deletePageDialog();
    });

    $(dom_scope).find(".cancelNewPageBtn").on("click",function(event){
        cmsPreventDefault(event);
        deletePageDialog();
    });

    $(dom_scope).find(".goToCurrentPageBtn").on("click",function(event){
        cmsPreventDefault(event);
        goToCurrentPageBtn();
    });

    $(dom_scope).find(".cancelUnsavedChangesBtn").on("click",function(event){
        cmsPreventDefault(event);
        cancelUnsavedChangesBtn();
    });

    $(dom_scope).find(".declinePageBtn").on("click",function(event){
        cmsPreventDefault(event);
        ldr("declining ...");
        $.ajax({
            type: 'post',
            timeout: content_manager.timeout_limit,
            data:{
                page_id: content_manager.page.history_page.id
            },
            cache: false,
            url: 'ajax/unmark_ready_for_review.php',
        })
        .done(function() {
            content_manager.page.history_page.review_status = 0;
            processUnsavedChangesStatus();
            var title = "Alert editor?",
                text = "<p>Would you like to alert the editor regarding the decline?</p>";
                text += "<p>You may also enter a message</p>";
                text += "<form class='dialogBoxForm' onkeypress='return event.keyCode != 13;'>";
                text += "<fieldset>";
                text += "<div class='row'>";
                text += "<input type='text' name='decline_comment' id='decline_comment' class='text ui-widget-content ui-corner-all' />";
                text += "</div>";
                text += "</fieldset>";
                text += "</form>";
            $('#dialog').html(text);
            $('#dialog').dialog('option', 'title', title);
            $('#dialog').dialog('option', 'width', '427px');
            $('#dialog').dialog('option', 'buttons', {
                "Yes": function () {
                    $(this).dialog("close");
                    $.ajax({
                        type: 'post',
                        cache: false,
                        url: 'ajax/alert_editor.php',
                        data: {
                            page_id: content_manager.page.history_page.id,
                            user_name: content_manager.page.history_page.author_name,
                            user_id: content_manager.page.history_page.author_admin_user_id,
                            type: "decline",
                            message: $("#decline_comment").val()
                        }
                    })
                    .done(function(){
                        ldrSuccess();
                    })
                    .fail(function(jq_xhr, text_status, error_thrown) {
                        if (content_manager.debug === 1) {
                            consoleLogAjaxFailure(jq_xhr, text_status, error_thrown);
                        }
                        ldrFailure();
                    })
                },
                "No": function () {
                    $(this).dialog("close");
                     ldrSuccess();
                }
            })
            $('#dialog').dialog('open');
        });
    });

    $(dom_scope).find(".savePageBtn").on("click",function(event){
        cmsPreventDefault(event);
        if (cmPanelDynamicData.HISTORY) {
            savePageVersion();
        } else {
            savePage();
        }
    });

    $(dom_scope).find(".saveForReviewPageBtn").on("click",function(event){
        cmsPreventDefault(event);
        requestPageReview($(this));
    });

    $(dom_scope).find(".commitPageBtn").on("click",function(event){
        cmsPreventDefault(event);
        commitPageBtn($(this));
    });

    $(dom_scope).find(".saveTriggerBtn").on("click",function(event){
        cmsPreventDefault(event);
        savePage(true);
    });

    $(dom_scope).find(".saveNewPageBtn").on("click",function(event){
        cmsPreventDefault(event);
        savePage(true);
    });

    $(dom_scope).find(".newPageBtn").on("click",function(event){
        let page_type = $(this).data('page-type');
        cmsPreventDefault(event);
        return newPage(page_type);
    });

    $(dom_scope).find(".cms-buttom-page").click(function(event) {
        cmsPreventDefault(event);
        return anchorClickLoadPage($(this));
    });

    $(dom_scope).find(".languageSelect").on("change",function(event){
        cmsPreventDefault(event);
        changeLanguage($(this).val());
    });

    $(dom_scope).find('.listingDateArchive').on("change", function(event){
        cmsPreventDefault(event);
        $("#listing_page").val(1); // reset pagination
        getListingList();
        return false;
    });

    $(dom_scope).find('.listingAdvFilterInputOnChange').on("change", function (event) {
        cmsPreventDefault(event);
        $("#listing_page").val(1); // reset pagination
        getListingList();
        return false;
    });

    var listingAdvFilterInputOnInputInterval = null;
    $(dom_scope).find('.listingAdvFilterInputOnInput').on("input", function (event) {
        clearInterval(listingQuickSearchInterval);
        // i dont want this to trigger right as user is typing - but a seoncd after he finished
        listingQuickSearchInterval = setInterval(
            function () {
                $("#listing_page").val(1); // reset pagination
                getListingList();
                clearInterval(listingQuickSearchInterval);
            },
        1000); // minute
    });

    $(dom_scope).find(".listingLimit").on("change",function(event){
        cmsPreventDefault(event);
        localStorage.setItem("page_id_"+getPageId("live")+"_listing_limit", $(this).val());
        $("#listing_page").val(1); // reset pagination
        getListingList();
    });

    var listingQuickSearchInterval = null;
    $(dom_scope).find(".listingQuickSearch").on("input",function(event){
        clearInterval(listingQuickSearchInterval);
        // i dont want this to trigger right as user is typing - but a seoncd after he finished
        listingQuickSearchInterval = setInterval(
            function(){
                $("#listing_page").val(1); // reset pagination
                getListingList();
                clearInterval(listingQuickSearchInterval);
            },
        1000); // minute
    });

    if ( $(".listingLimit").length > 0 ) {
        listing_limit_value = localStorage.getItem("page_id_"+getPageId("live")+"_listing_limit");
        if ( listing_limit_value !== null && typeof listing_limit_value !== "undefined" ) {
            $(".listingLimit").val(listing_limit_value);
        }
    }

    if ( $(".saveNewPageBtn").length > 0 ) {
        pingPage();
    }

    if ( content_manager.page !== null && typeof content_manager.page.language_ignored_page !== "undefined" && content_manager.page.language_ignored_page === true ) {
        $(".languageSelectFieldset").hide();
    } else {
        $(".languageSelectFieldset").show();
    }

    $(dom_scope).find(".page-listing-container-settings-btn").fancybox({
        type: 'iframe',
        fitToView : false,
        autoSize : false,
        height : 900,
        width : 1200,
        beforeClose: function () {
            ldrPending("refreshing...");
            getPage(getPageId("live"), function(page){
                treatPage(page);
            });
        }
    });


    $(dom_scope).on("keypress", 'form', function (e) {
        var code = e.keyCode || e.which;
        if (code == 13) {
            e.preventDefault();
            return false;
        }
    });


    $(dom_scope).find('.page-preview-btn').on("click", function(event) {
        cmsPreventDefault(event);
        pagePreviewBtn(getPageId("live"));
        return false;
    });

    $(dom_scope).find('.page-adv-preview-btn').on("click", function(event) {
        cmsPreventDefault(event);
        pageAdvPreviewBtn($(this));
        return false;
    });

    $(dom_scope).find('a.viewVersion').on("click", function(event){
        cmsPreventDefault(event);
        viewVersionBtn($(this));
        return false;
    });

    $(dom_scope).find('a.goToAlert').on("click", function(event){
        $(".alertFieldset").hide();
    });

    /**
     * Adding handler listener for admin option lock change event
     */
    $(dom_scope).find('.settingLockOption input').on("change", function(event) {
        cmsPreventDefault(event);
        toggleSettingsLock($(this));
    });

    $(dom_scope).find('.storePagedataStructureInTheTemplateBtn').on("click", function(event) {
        cmsPreventDefault(event);
        storePagedataStructureInTheTemplateAction();
    });

    $(dom_scope).find('.loadPagedataStructureFromTheTemplateBtn').on("click", function(event) {
        cmsPreventDefault(event);
        loadPagedataStructureFromTheTemplateAction();
    });

    $(dom_scope).find('#data\\[page\\]\\[template\\]').on("change", function () {
        // First check for admin funtionality where they can load up structure on temp pages.
        if (
            cmPanelDynamicData.IS_ADMIN === true &&
            content_manager.page.type === "temp" &&
            $(this).children("option:selected").attr("data-has-structure") === "true"
        ) {
            loadPagedataStructureFromTheTemplateAction();
        // Secondly check for client functionality where they can load up structure for any page is allowed and has structure
        } else if (
            cmPanelDynamicData.IS_ADMIN === false &&
            $(this).children("option:selected").attr("data-has-structure") === "true" && // if there is not strucuture, there's no changes.
            $(this).children("option:selected").attr("data-allow-client-tpl-change") === "true"
        ) {
            clientSwitchTemplatesDialogue();
        }
    });

    $(dom_scope).find('a.copyAllListedPages').on("click", function (event) {
        cmsPreventDefault(event);
        if (busyLoading()) {
            return false;
        }
        copyPagesDialogue(
            getListingPageListedPageIDs(),
            "listing_tab"
        );
    });

    $(dom_scope).find('a.set-allowed-templates-for-switching-btn').on("click", function (event) {
        cmsPreventDefault(event);
        if (busyLoading()) {
            return false;
        }
        if (content_manager.site_tree === null) {
            ldrPending("opening dialog...");
             getSiteTree(
                getPageId(),
                function () {
                    ldrSuccess();
                    setAllowedTemplatesForSwitchingDialogue();
                }
            );
        } else {
            setAllowedTemplatesForSwitchingDialogue();
        }
    });

    $(dom_scope).find("#data\\[page\\]\\[slug\\]")
    .off("keyup", function () {
        checkSlugForConflicts($(this));
    })
    .on("keyup", function () {
        checkSlugForConflicts($(this));
    })
    .off("change", function () {
        checkSlugForConflicts($(this));
    })
    .on("change", function () {
        checkSlugForConflicts($(this));
    });

    $('.changeListedPagesSubId').on("click", function (event) {
        cmsPreventDefault(event);
        if (busyLoading()) {
            return false;
        }
        movePagesDialog(
            getListingPageListedPageIDs()
        );
        return false;
    });

    setUnsavedChanges(false);
    processUnsavedChangesStatus();

    for (var attr in content_manager.page) {
        $(dom_scope).find("#data\\[page\\]\\["+attr+"\\]")
            .off("keyup", function(){setUnsavedChanges()})
            .on("keyup", function(){setUnsavedChanges()})
            .off("change", function(){setUnsavedChanges()})
            .on("change", function(){setUnsavedChanges()})
        ;
    }

    panelInitCustom(dom_scope);

    fieldsetToggles(dom_scope);

    $('.moveSelectedBtn').on("click", function(event) {
        event.preventDefault();

        if ($('[name^=bulk_selection_page_ids]:checked').length > 0) {
            $(".moveSelectedDropdownWrap").show();
            $(".moveSelectedBtn").hide();
        } else {
            alert("Nothing selected.");
        }
    });

    $(".moveSelectedAction").on("click", function(event) {
        event.preventDefault();
        let parent_id = $(".moveSelectedDropdown").val();

        let page_ids_to_move = [];
        $('[name^=bulk_selection_page_ids]:checked').each(function() {
            page_ids_to_move.push($(this).val());
        })

        let current_page_id = $(this).data("current-page-id");

        $.ajax({
            type: 'post',
            data:{
                new_sub_id: parent_id,
                page_ids: page_ids_to_move,
                current_page_id: current_page_id,
            },
            cache: false,
            url: 'ajax/move_page.php',
        })
        .complete(function() {
            location.reload();
        })
    });
}
