<?php
/**
 * Illuminate/Routing
 *
 * @source https://github.com/illuminate/routing
 * @contributor Muhammed Gufran
 * @contributor Matt Stauffer
 * @contributor https://github.com/jwalton512
 * @contributor https://github.com/dead23angel
 */

use Illuminate\Container\Container;
use Illuminate\Events\Dispatcher;
use Illuminate\Http\Request;
use Illuminate\Routing\Router;
use Illuminate\Contracts\Http\Kernel;


define('LARAVEL_START', microtime(true));

$path = './';

require_once __DIR__ . '/core/includes/header.inc.php';

// Create a service container
//$container = new Container;

// Create a request from server variables, and bind it to the container; optional
//$request = Request::capture();
//$container->instance('Illuminate\Http\Request', $request);

// Using Illuminate/Events/Dispatcher here (not required); any implementation of
// Illuminate/Contracts/Event/Dispatcher is acceptable
//$events = new Dispatcher($container);

/** @var Router $router */
//$router = \Illuminate\Support\Facades\App::make(Router::class);

\Illuminate\Support\Facades\App::instance('page_meta', $page_meta);

/** @var \Illuminate\Contracts\Http\Kernel $kernel */
//$kernel = \Illuminate\Support\Facades\App::make(Kernel::class);

$kernel = app()->make(Kernel::class);

$response = $kernel->handle(
    $request = Request::capture()
);

if ($response->getStatusCode() == 404) {
    define('CMS_FALLBACK', true);
    require_once base_path('core/index.php');
    exit;
}

//if ($response->getStatusCode() == 403) {
//    header("HTTP/1.0 403 Forbidden");
//    echo template('errors/403.twig');
//    exit;
//}

$response->send();

$kernel->terminate($request, $response);
