<?php

$path = '../../../';
require_once $path.'core/includes/header.inc.php';

init_request_values([
    'id' => null,
]);

use Mtc\Modules\BasketRecovery\Classes\BasketRecovery;
$errors = [];
$page_name = 'Follow-Up';
$page['title'] = "Manage {$page_name}s";
$section = 'shop';

if ($_REQUEST['id'] > 0) {
    $item = BasketRecovery::query()->find($_REQUEST['id']);
} else {
    $item = new BasketRecovery();
}

if (filter_input(INPUT_POST, 'action') === 'edit') {
    if (filter_input(INPUT_POST, 'type') === '') {
        $errors['type'] = 'Follow-up type must be specified';
    }
    
    if (empty($errors)) {
        try {
            $item->fill($_POST);
            $item->setInterval($_POST['interval_unit'], $_POST['interval_measure']);
            $item->save();

            $_SESSION['message'] = 'Entry saved';
            header('Location: edit.php?id=' . $item->id);
            exit();
        } catch (Exception $e) {
            $errors[] = $e->getMessage();
        }
    }
}

require $path.'core/admin/templates/adminheader.html.php';
require __DIR__.'/templates/edit.tpl.php';
require $path.'core/admin/templates/adminfooter.html.php';
