<?php

namespace Mtc\Plugins\MtcUnioIntegration\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Mtc\Plugins\MtcUnioIntegration\Classes\QueueMessageToUnio;
use Mtc\Plugins\MtcUnioIntegration\Classes\QueueMessageFromUnio;
use Illuminate\Support\Facades\Artisan;


class QueueController extends \App\Http\Controllers\Controller
{

    public function to_unio()
    {
        $queue_messages = QueueMessageToUnio::query()
            ->orderBy('created_at', 'desc')
            ->paginate(50)
        ;

        return template('admin/queue_manage.twig', [
            'selected_tab' => 'to_unio',
            'title' => 'Queue (messages to Unio)',
            'queue_messages' => $queue_messages,
            'actions' => [
                [
                    'button_route' => 'admin-unio-queue-to-unio-get-payload',
                    'button_label' => 'View payload',
                ],
                [
                    'button_route' => 'admin-unio-queue-to-unio-get-response',
                    'button_label' => 'View response',
                ],
            ],
        ]);
    }


    public function from_unio()
    {
        $queue_messages = QueueMessageFromUnio::query()
            ->orderBy('created_at', 'desc')
            ->paginate(50)
        ;

        return template('admin/queue_manage.twig', [
            'selected_tab' => 'from_unio',
            'title' => 'Queue (messages from Unio)',
            'queue_messages' => $queue_messages,
            'actions' => [
                [
                    'button_route' => 'admin-unio-queue-from-unio-get-payload-received',
                    'button_label' => 'View payload',
                ],
                [
                    'button_route' => 'admin-unio-queue-from-unio-get-response',
                    'button_label' => 'View response',
                ],
            ],
        ]);
    }


    public function to_unio_payload($message_id)
    {
        ob_start();
        Artisan::call('unioqueue:process_messages_to_unio', [
            '--dry-run' => true,
            'message_id' => [ $message_id ],
        ]);
        $output = ob_get_clean();

        $payload = json_decode($output, true);

        return $payload;
    }


    public function to_unio_response($message_id)
    {
        $message = QueueMessageToUnio::findOrFail($message_id);

        $payload = json_decode($message->response, true);

        if (is_null($payload)) {
            $payload = $message->response;
        }

        if (is_null($payload)) {
            $payload = 'NULL';
        }

        return $payload;
    }


    public function from_unio_payload_received($message_id)
    {
        $message = QueueMessageFromUnio::findOrFail($message_id);

        $payload = json_decode($message->payload_received, true);

        return $payload;
    }


    public function from_unio_response($message_id)
    {
        $message = QueueMessageFromUnio::findOrFail($message_id);

        $payload = json_decode($message->response, true);

        if (is_null($payload)) {
            $payload = $message->response;
        }

        if (is_null($payload)) {
            $payload = 'NULL';
        }

        return $payload;
    }
}

