<?php

use Illuminate\Support\Facades\Event;
use Mtc\Plugins\NHS\Classes\Prescription;
use Mtc\Shop\Events\OrderPaidEvent;

Event::listen(OrderPaidEvent::class, function($event) {

    $order = $event->getOrder()->eloquent();

    foreach ($order->items as $order_item) {
        if (empty($order_item->prescription_item->prescription)) {
            continue;
        }
        $order_item->prescription_item->prescription->save_status(Prescription::STATUS_COMPLETE);
    }

});


require_once $path . 'shop/includes/functions.php';
