<?php

$display_message = false;

if (empty($path)) {
    $path = '../../../';
    require_once $path . 'core/includes/header.inc.php';
    $display_message = true;
}

/**
 * Install file for Share Icon variables
 *
 * @author Andrew Morgan <andrew.morgan@mtcmedia.co.uk>
 */

use Illuminate\Database\Capsule\Manager as Capsule;
use \Mtc\Plugins\ShareButtons\Classes\ShareButtons;

$schema = Capsule::connection()->getSchemaBuilder();

// Get the path to the admin folder without public_html / fork directory
$path_to_admin_folder = str_replace(SITE_PATH, '', dirname(__DIR__));

// Flag for table being installed
$missing_tables = false;

// Verify share_buttons table exists and create if it does not
if ($schema->hasTable('share_buttons') === false) {

    $schema->create(
        'share_buttons', function ($table) {
            $table->increments('id')->unsigned;
            $table->string('social_network');
            $table->string('social_button_link');
            $table->string('social_button_class');
            $table->string('social_button_text');
            $table->string('social_button_icon');
            $table->integer('order')->default(0);
            $table->integer('hide');
            $table->timestamps();
        }
    );

    /*
     * Insert some default data to get us started
     */

    ShareButtons::create([
        'social_network' => 'Twitter',
        'social_button_link' => 'http://www.twitter.com/',
        'social_button_class' => 'twitterFollowLink',
        'social_button_text' => 'Share with Twitter',
        'social_button_icon' => 'fa fa-twitter',
        'hide' => 0,
    ]);

    ShareButtons::create([
        'social_network' => 'Facebook',
        'social_button_link' => 'http://www.facebook.com/',
        'social_button_class' => 'facebookFollowLink',
        'social_button_text' => 'Share with Facebook',
        'social_button_icon' => 'fa fa-facebook',
        'hide' => 0,
    ]);

    ShareButtons::create([
        'social_network' => 'Google',
        'social_button_link' => 'http://www.google.com/',
        'social_button_class' => 'googleFollowLink',
        'social_button_text' => 'Share with Google+',
        'social_button_icon' => 'fa fa-google',
        'hide' => 0,
    ]);

    ShareButtons::create([
        'social_network' => 'LinkedIn',
        'social_button_link' => 'http://www.linkedin.com/',
        'social_button_class' => 'linkedinFollowLink',
        'social_button_text' => 'Share with LinkedIn',
        'social_button_icon' => 'fa fa-linkedin',
        'hide' => 1,
    ]);

    ShareButtons::create([
        'social_network' => 'Pinterest',
        'social_button_link' => 'http://www.pinterest.com/',
        'social_button_class' => 'pinterestFollowLink',
        'social_button_text' => 'Share with Pinterest',
        'social_button_icon' => 'fa fa-pinterest-p',
        'hide' => 1,
    ]);

}

/*
 * Create the admin menu item
 *
 * Currently added under "Mtc Only" menu but could be given to clients
 */

$setting_check = Capsule::table("admin_menu")->where('constant', 'SHARE_BUTTONS_INSTALLED')->exists();

if (empty($setting_check)) {

    Capsule::table('admin_menu')->insert(
        [
            'sub_id' => 1,
            'title' => 'Share Buttons',
            'path' => $path_to_admin_folder,
            'activePath' => $path_to_admin_folder,
            'constant' => 'SHARE_BUTTONS_INSTALLED',
            'icon' => 'fa fa-share-alt',
            'new_window' => 0,
            'order' => 2,
        ]
    );

}

/*
 * Mark plugin as installed
 *
 * This plugin is never really enabled or disabled this flag
 * is only used to track if it has its settings in place to
 * skip installation from being run again.
 */
$data = [
    [
        'key' => 'SHARE_BUTTONS_INSTALLED',
        'type' => 'bool',
        'value' => 1,
        'module' => 'SHARE_BUTTONS',
        'description' => 'Install setting flag for Sharing Buttons',
        'created_at' => new DateTime(),
    ],
];

foreach ($data as $key => $values) {
    if (defined($values['key'])) {
        unset($data[$key]);
    }
}

MTC\Core\Setting::Insert($data);

if ($display_message === true) {
    exit('Install successful');
}
