<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class TwigClear extends Command
{
    protected $signature = 'twig:clear';
    protected $description = 'Clear the Twig compiled template cache';

    public function handle(): int
    {
        $path = storage_path('framework/cache/twig');

        if (!is_dir($path)) {
            $this->info('Twig cache directory does not exist.');
            return self::SUCCESS;
        }

        $deleted = File::deleteDirectory($path) || File::cleanDirectory($path);
        $this->info($deleted ? "Twig Cache Cleared: $path" : "Failed to clear: $path (check permissions)");
        return $deleted ? self::SUCCESS : self::FAILURE;
    }
}
