<?php

namespace App\Console;

use App\Console\Commands\CatalogImportCommand;
use App\Console\Commands\DatabaseSeederCommand;
use App\Console\Commands\DecryptDbFields;
use App\Console\Commands\EncryptDbFields;
use App\Console\Commands\FetchRemoteScriptsCommand;
use App\Console\Commands\FixItemStock;
use App\Console\Commands\FollowUpsSendCommand;
use App\Console\Commands\GenerateOrdersFromSubscriptionsCommand;
use App\Console\Commands\GenerateSitemapCommand;
use App\Console\Commands\GenerateSubscriptionsCommand;
use App\Console\Commands\ImportCmsPagesCommand;
use App\Console\Commands\ParseProductDescriptionsCommand;
use App\Console\Commands\RyftCapturePaymentsCommand;
use App\Console\Commands\SendQueuedEmailsCommand;
use App\Console\Commands\SitemapRunCrawlCommand;
use App\Console\Commands\SyncDeliveryServiceOptionCommand;
use App\Console\Commands\TwigClear;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use MtcPharmacy\Multisite\Console\Commands\DeleteCustomRecordsCommand;
use MtcPharmacy\Multisite\Console\Commands\EnsureAllRecordsAreMultisiteReadyCommand;
use MtcPharmacy\OutOfStockNotify\Console\Commands\SendBackInStockNotificationsCommand;
use Mtc\Plugins\NHS\Commands\DeleteStaleMembers;
use Mtc\Plugins\NHS\Commands\NhsToolboxCommand;


class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        CatalogImportCommand::class,
        DeleteCustomRecordsCommand::class,
        DeleteStaleMembers::class,
        EnsureAllRecordsAreMultisiteReadyCommand::class,
        FixItemStock::class,
        GenerateOrdersFromSubscriptionsCommand::class,
        GenerateSitemapCommand::class,
        GenerateSubscriptionsCommand::class,
        ImportCmsPagesCommand::class,
        NhsToolboxCommand::class,
        ParseProductDescriptionsCommand::class,
        SendBackInStockNotificationsCommand::class,
        RyftCapturePaymentsCommand::class,
        DatabaseSeederCommand::class,
        FollowUpsSendCommand::class,
        SendQueuedEmailsCommand::class,
        SitemapRunCrawlCommand::class,
        FetchRemoteScriptsCommand::class,
        SyncDeliveryServiceOptionCommand::class,
        EncryptDbFields::class,
        DecryptDbFields::class,
        TwigClear::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param Schedule $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule): void
    {
        if (config('queue.default') === 'database') {
            $schedule->command('queue:work --timeout=3600 --stop-when-empty')
                ->everyMinute()
                ->withoutOverlapping();
        }

        $schedule->call(RyftCapturePaymentsCommand::class)
            ->hourly();
        $schedule->call(SendBackInStockNotificationsCommand::class)
            ->everyThirtyMinutes();
        $schedule->call(GenerateSitemapCommand::class)
            ->dailyAt('05:15');
        $schedule->command('followUps:run')
            ->everyMinute()
            ->withoutOverlapping();
        $schedule->command('emailsQueued:send')
            ->everyTenMinutes()
            ->withoutOverlapping();
        $schedule->call(SitemapRunCrawlCommand::class)
            ->dailyAt('02:13');
        $schedule->call(FetchRemoteScriptsCommand::class)
            ->everyThirtyMinutes();
    }
}
