<?php

namespace App\Events;

use Illuminate\Http\Request;
use Mtc\Shop\Assessment\Assessment;

/**
 * Class AssessmentCreatedEvent
 *
 * Event triggered before assessment form is loaded
 *
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk
 * @version 14.11.2024
 */
class AssessmentInitEvent
{
    /**
     * @var Request $request
     */
    protected Request $request;

    /**
     * @return Request
     */
    public function getRequest(): Request
    {
        return $this->request;
    }

    /**
     * @param Request $request
     */
    public function __construct(Request $request)
    {
        $this->request = $request;
    }
}
