<?php

namespace App\Events;

/**
 * Class BasketRemoveItemEvent
 *
 * Event triggered when Basket item is removed
 *
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk
 * @version 25.11.2020
 */
class BasketRemoveItemEvent
{

    /**
     * @var $basketItemID
     */
    protected $basketItemID;

    /**
     * @return mixed
     */
    public function getBasketItemId()
    {
        return $this->basketItemID;
    }

    /**
     * @param $basketItemID
     */
    public function __construct($basketItemID)
    {
        $this->basketItemID = $basketItemID;
    }
}
