<?php

namespace App\Events;

use Mtc\Modules\Members\Models\Member;

/**
 * Class MemberCreatedEvent
 *
 * Event triggered when a member is created
 *
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk
 * @version 17.09.2024
 */
class MemberCreatedEvent
{

    /**
     * @var Member $member
     */
    protected Member $member;

    /**
     * @return Member
     */
    public function getMember(): Member
    {
        return $this->member;
    }

    /**
     * @param Member $member
     */
    public function __construct(Member $member)
    {
        $this->member = $member;
    }
}
