<?php

namespace App;

use Illuminate\Contracts\Support\MessageBag;

class FlashMessage
{

    public static function set(string $message) : void
    {
        $_SESSION['flash_message'] = $message;
    }


    public static function get() : string
    {
        $message = (string)$_SESSION['flash_message'];
        unset($_SESSION['flash_message']);

        return $message;
    }


    public static function getImplodedMessages(MessageBag $message_bag) : array
    {
        $errors_imploded = [];
        foreach ($message_bag->getMessages() as $field_name => $errors_array) {
            $errors_imploded[$field_name] = implode(",", $errors_array);
        }

        return $errors_imploded;
    }

}
