<?php

$cms_root_path = "../../../";
require_once($cms_root_path."includes/compatibility_includer.php");

if (empty($_GET['page_id']) || !is_numeric($_GET['page_id'])) {
    header("HTTP/1.0 400 Bad Request");
    $error_message = "page_id missing from add item request.";
    ContentManagerPanel::addMessage($error_message);
    die($error_message);
}

$page = ContentManagerPanel::loadPage($_GET['page_id'], false);
if (empty($page->id)) {
    header("HTTP/1.0 409 Conflict");
    $error_message = "The page in which you attempted to add the additional item was not found.";
    ContentManagerPanel::addMessage($error_message);
    die($error_message);
}

$language = "";
if ( !empty($_POST['language']) ) {
	$language = $_POST['language'];
}

Pagedata::addMoreItems($_POST, $page);
Pagedata::orderFix($_GET['page_id']);

$pagedata = new Pagedata();
$pagedata->setLanguage($language);
$pagedata->Get(0,$_POST['action_more']);

$list = $pagedata->pagedata[0];

if (empty($list)) {
    header("HTTP/1.0 409 Conflict");
    $error_message = "The list in which you attempted to add the additional item was not found.";
    ContentManagerPanel::addMessage($error_message);
    die($error_message);
}

// check if item to be selected from the top or bottom of the list
if (isset($list['add_list_item_to_top']) && $list['add_list_item_to_top'] == '1') {
	$item = $pagedata->pagedata[0]['items'][0];
} else {
	$item = end($pagedata->pagedata[0]['items']);
}

$item_number=1;
$item_list=true;
$fresh_added = true;
include("../templates/item/default.php");
