<?php
/**
 * Script for reprocessing slugs for pages recursively
 * @author Rihards Siliņš
 * @copyright MTC media Ltd
 */
$cms_root_path = '../../../';
require_once $cms_root_path . 'includes/compatibility_includer.php';

if (!isset($_GET['page_id']) || !is_numeric($_GET['page_id'])) {
    header("HTTP/1.0 400 Bad Request");
    exit("page_id in request not found");
}
$page_id = $_GET['page_id'];

$dry = 0;
if (isset($_GET['dry']) && $_GET['dry'] == 1) {
    $dry = $_GET['dry'];
}

if (isset($_GET['recursive_limit']) && is_numeric($_GET['recursive_limit'])) {
    $recursive_limit = $_GET['recursive_limit'];
} else {
    $recursive_limit = PHP_INT_MAX;
}

$content_manager = new ContentManager();
// process the newly created pages so they have a valid slug and are accessible
$result = $content_manager->processSlugsForPageAndSubs($page_id, $recursive_limit, 0, $dry);

exit(json_encode($result));
