<?php

//can be included from a different location
if (!isset($cms_root_path)) {
    $cms_root_path = "../../../";
}
require_once $cms_root_path . "includes/compatibility_includer.php";

$pagedata_lists = array();
$pagedata_lists = json_decode($_POST['pagedata_lists'], true);
if (empty($pagedata_lists)) {
    echo '<p>No Content</p>';
    exit();
}

$option_file_get_contents_cache = [];

foreach ($pagedata_lists as $key => $list) {

    //if this is a custom type that shouldn't be rendered, don't do it
    if (in_array($list['type'], \ContentManager::$pagelist_render_rules['skip'])) {
        continue;
    }

    // if not admin and is locked - don't skip
    if ( $list['lock'] && !$_SESSION['content_manager']['is_mtcadmin'] ) {
        continue;
    }

    $item_list = false;
    // If this list allows more items or has an item with several data/fields - show it as an expandable list
    if ( $list['allow_more'] == 1 || count($list['items'][key($list['items'])]['data'] ?? []) > 1 || count($list['items']) > 1 ) {
        $item_list = true;
    }

    // check if list item to be added to the top of the list
    if ( $list['add_list_item_to_top'] == 1) {
        echo '<input type="hidden" name="add_list_item_to_top" value="1">';
    }

    echo '<li
        id="list_'.$list['id'].'"
        data-name="'.$list['name'].'"
        data-complexity="'.( $item_list ? "item_list" : "single_item" ).'"
    >';
    //echo "<ul><li></li></ul>";

    // only movable if dev
    if ( $_SESSION['content_manager']['is_mtcadmin'] ) {
        echo    '<i class="handle fa fa-ellipsis-v"></i>';
    }

    echo '<fieldset
        class="
            '.( $item_list ? "item_list" : "simple_items" ).'
            '.( $_SESSION['content_manager']['is_mtcadmin'] ? 'is_mtcadmin' : '' ).'
        "
        id="list_fieldset_'.$list['id'].'"
    >';

    //allow custom types to be rendered to be rendered in a custom manner
    if (in_array($list['type'], \ContentManager::$pagelist_render_rules['render'])) {
        HooksAdapter::do_action('cms_render_plugin_list', $list);
        $list['items'] = [];
    } elseif ( $item_list ) {
        // If this list allows mor items or has an item with several data/fields - show it as an expandable list

        echo    '<h1>';
            ?>
            <a class="show el">
                <span id="item_list_<?= clean_page($list['id']) ?>">
                    <?= clean_page($list['name']) ?>
                </span>
                <i class="fa fa-caret-down"></i>
            </a>
            <?php
        echo    '</h1><div style="clear:both"></div>';

        echo    '<div>';

        echo        '<div class="page-list-button-header">';

        if ( $list['allow_more'] ) {
            echo        '<a data-list-id="'.$list['id'].'" class="add-new-list-item-btn-anchor" href="#" id="list-'.$list['id'].'-more-btn"><button type="button" class="btn add-new-list-item-btn">'.$list['more_text'].'</button></a>';
            echo        '<input type="text" value="'.$list['more_text'].'" class="list-more_text-input" id="list-'.$list['id'].'-more_text" style="display:none" />';
        }

        if ( !empty($list['info']) ) {
            echo        '<div class="hint el"><i class="fa fa-info-circle"></i><div class="text">'.$list['info'].'</div></div>';
        }

        if ($_SESSION['content_manager']['is_mtcadmin']) {
            if ( $list['allow_more'] ) {

                echo            '<i class="fa fa-pencil list-change-more-text-btn" id="list-'.$list['id'].'-more_text-btn" data-list-id="'.$list['id'].'" data-open="false"></i>';
                echo                '<img class="ajax-loader ajax-loader-smaller" src="/admin/images/ajax.gif" id="list-'.$list['id'].'-change-more-text-btn-loader" alt="Loading..." style="display:none" />';

            }

            echo            '<i class="'.( empty($list['lock']) ? 'fa fa-unlock' : 'fa fa-lock' ).' list-lock-btn" id="list-'.$list['id'].'-lock-btn" data-list-id="'.$list['id'].'"></i>';
            echo                '<img class="ajax-loader ajax-loader-smaller" src="/admin/images/ajax.gif" id="list-'.$list['id'].'-lock-btn-loader" alt="Loading..." style="display:none" />';

            echo            '<i class="fa fa-cog list-settings-btn"></i>';
            echo            '<i class="fa fa-copy pagedata-copy-btn" data-item-list-id="'.$list['id'].'" data-item-list-name="'.$list['name'].'"></i>';
            echo            '<i class="fa fa-trash list-delete-btn" data-item-list-id="'.$list['id'].'" data-item-list-name="'.$list['name'].'"></i>';
        }

            echo        '<div class="list-settings"  style="display:none">';
            echo            '<div class="row">';
            echo                '<label>More:</label><input type="checkbox" name="allow_more" value="1" '.( empty($list['allow_more']) ? '' : 'checked' ).' />';
            $checked = "";
            if (!empty($list['add_list_item_to_top'])) {
                $checked = "checked";
            }
            echo                '<label>Add List Item To Top:</label><input type="checkbox" name="item_list_top" value="1" '.$checked.' />';
            echo                '<label>List Name:</label><input type="text" name="item_list_name" value="'.$list['name'].'" />';
            echo                '<label>List Info:</label><input type="text" name="item_list_info" value="'.$list['info'].'" />';
            echo                '<label>List Type:</label><input type="text" name="item_list_type" list="item_list_types" value="'.$list['type'].'" />';
                                ?>
                                <label>Item Max:</label>
                                <input type="text" name="item_list_allow_more_max" value="<?=clean_page($list['allow_more_max'])?>" />
                                <label>Item Min:</label>
                                <input type="text" name="item_list_allow_more_min" value="<?=clean_page($list['allow_more_min'])?>" />
                                <?php
            echo                '<datalist id="item_list_types">';
            echo                    '<option value="singleImageItemList">';
            echo                '</datalist>';
            echo                '<button class="btn save-list-settings" data-item-list-id="'.$list['id'].'">Save</button>';
            echo                '<img class="ajax-loader" src="/admin/images/ajax.gif" alt="Loading..." style="display:none" />';
            echo            '</div>';
            echo     '<div style="clear:both"></div></div>';
    }

        echo '<div style="clear:both"></div>';
        echo    '</div>';

        $item_number = 0;

        echo '<div class=" list-item-holder" id="list-'.$list['id'].'-item-holder">';

        foreach ($list['items'] as $key => $item) {

            include("item/default.php");

            $item_number++;

        }

        echo '<div style="clear:both"></div></div><!--/listitem-holder-->';

    echo '</fieldset>';
echo '<div style="clear:both"></div>';
     echo '</li>';

}

?>
