<?php

$cms_root_path = "../../../";
require_once($cms_root_path."includes/compatibility_includer.php");

if (!empty($_POST['json'])) {
    $post = json_decode($_POST['json'], true);
}
if (empty($post)) {
    $post = array();
}

$cm = new ContentManager();
$cm->setTwigLoader($twig_loader);
$op = new PageOptions();
$admin_options = $op->getAdmin();

unset($admin_options['listing_container']);
unset($admin_options['template']);
unset($admin_options['allow_delete']);

?>

<div class="pageActionBtns clearfix">

	<button class="btn greenBtn saveNewPageBtn">SAVE</button>
	<button class="btn redBtn cancelNewPageBtn">DELETE</button>

	<?php
	if ( $_SESSION['content_manager']['is_mtcadmin'] ) {
		?>

	<fieldset class="topBarButtonFieldset pagedataFieldset">
		<span class="pagedataFieldsetLabel topBarButtonFieldsetLabel">Pagedata</span>
		<a href="#" class="add-page-pagedata-btn" title="Add a pagedata field">
			<i class="fa fa-plus-circle"></i>
			<div id="pagedataTypes" class="hidden" data-types='<?=json_encode(ContentManager::$pagedata_types)?>'></div>
		</a>
		<a href="#" class="pagedata-copy-btn copy-page-pagedata-btn" title="Copy all a pagedata fields on this page">
			<i class="fa fa-copy"></i>
		</a>
		<a href="#" class="paste-page-pagedata-btn" title="Paste pagedata fields into this page">
			<i class="fa fa-paste"></i>
		</a>
        <a href="#" class="storePagedataStructureInTheTemplateBtn tooltip" title="Store pagedata structure in the template. Allowing new pages to load fields directly from and for the template.">
            <i class="fa fa-suitcase"></i>
        </a>

        <a href="#" class="loadPagedataStructureFromTheTemplateBtn tooltip" title="Load pagedata structure from the template.">
            <i class="fa fa-newspaper-o"></i>
        </a>
	</fieldset>

		<?php
	}
	?>

	<div class="controlPanelLoaderContainerInActionBtns">
		<div id="controlPanelLoader" class="controlPanelLoader">
			<main>
			  <span class="spinner"></span>
			</main>
			<span class="loaderMessage">loading...</span>
		</div>
	</div>

</div>

<form method="post" action="" class="mainForm" enctype="multipart/form-data">

	<div class="styleBox">

		<?php include("edit_page_basics.php"); ?>

		<?php
    	if ( $_SESSION['content_manager']['is_mtcadmin'] || CMS_ALLOW_CLIENT_TO_EDIT_SEO === true ) {
			include("edit_page_seo.php");
		}
		?>

		<?php
		if ( $_SESSION['content_manager']['is_mtcadmin'] == true || $_SESSION['content_manager']['is_mtcadmin'] == false && empty($_GET['lock'])) {
			include("edit_page_settings.php");
			include("edit_page_pagedata.php");
		}
		?>

	</div>

</form>
